<?php
/*
  Plugin Name: DZS ZoomSounds
  Plugin URI: https://digitalzoomstudio.net/
  Description: Creates cool audio players with optional playlists for your site.
  Version: 6.11
  Author: Digital Zoom Studio
  Author URI: https://digitalzoomstudio.net/
 */

define("DZSAP_VERSION", '6.11');

define('DZSAP_BASE_PATH', (dirname(__FILE__)).DIRECTORY_SEPARATOR);
if (function_exists('plugin_dir_url')) {
  define('DZSAP_BASE_URL', plugin_dir_url(__FILE__));
}

include_once(DZSAP_BASE_PATH . 'dzs_functions.php');

$classPath = DZSAP_BASE_PATH . 'class-dzsap.php';

if (!class_exists('DZSAudioPlayer')) {
  include_once($classPath);
}


if (class_exists('DZSAudioPlayer')) {
  $dzsap = new DZSAudioPlayer();
}


if (class_exists('Cornerstone_Plugin')) {
  include_once(DZSAP_BASE_PATH . 'inc/php/cornerstone/cornerstone-functions.php');
  add_action('wp_enqueue_scripts', 'dzsap_cs_enqueue');
  add_action('cornerstone_register_elements', 'dzsap_cs_register_elements');
  add_filter('cornerstone_icon_map', 'dzsap_cs_icon_map');
  add_action('cornerstone_before_wp_editor', 'dzsap_cs_home_before');
  add_action('cornerstone_load_builder', 'dzsap_cs_home_before');
}