<?php

function dzsap_shortcode_init_listeners() {

  add_shortcode('dzsap_woo_grid', 'dzsap_shortcode_woo_grid');
  add_shortcode('player_button', 'dzsap_shortcode_player_button');


  add_shortcode(DZSAP_ZOOMSOUNDS_ACRONYM . '_in_lightbox', 'dzsap_shortcode_lightbox');
  add_shortcode(DZSAP_ZOOMSOUNDS_ACRONYM . '_showcase', 'dzsap_shortcode_showcase');
  add_shortcode('dzsap_wishlist', 'dzsap_shortcode_wishlist');
  add_shortcode('dzsap_search_con', 'dzsap_shortcode_search_con');
  add_shortcode('dzsap_search', 'dzsap_shortcode_search');
}

/**
 * [player_button style="player-but"]label[/player_button]
 * @param $atts
 * @param null $content
 * @return string
 */
function dzsap_shortcode_player_button($atts, $content = null) {

  // --
  global $dzsap;

  //print_r($current_user->data);
  //echo 'ceva'.isset($current_user->data->user_nicename);


//        error_log('ratatata');
  $fout = '';


  $margs = array(
    'link' => '',
    'style' => '', // -- "btn-zoomsounds" or "player-but"
    'label' => '',
    'icon' => '',
    'color' => '',
    'target' => '',
    'background_color' => '',
    'extra_classes' => '',
    'wrap_object' => 'on', // -- this will allow a inside a html tag ( default on )
    'extraattr' => '',
    'post_id' => '',
  );

  if ($atts) {

    $margs = array_merge($margs, $atts);
  }

  // process
  if ($content) {
    $margs['label'] = $content;
  }

  // END process margs
//  print_rr('dzsap_shortcode_player_button' . print_r($margs, true));


//        echo 'shortcode_player_button margs - '; print_rr($margs);

  $startDomTag = 'div';
  if ($margs['link']) {
    $startDomTag = 'a';
    if ($margs['wrap_object'] == 'on') {
      $startDomTag = 'object';
    }
  }


  $anchorExtraAttr = '';

  if ($margs['link']) {
    $anchorExtraAttr .= ' href="' . $margs['link'] . '"';
  }


//  $anchorExtraAttr.='alceva';
  if ($margs['target']) {

    $anchorExtraAttr .= ' target="' . $margs['target'] . '"';
  } else {

    $anchorExtraAttr .= ' target="' . '' . '"';
  }

  $anchorExtraAttr .= ' class="' . $margs['style'] . '';

  if ($margs['style'] === 'player-but') {
    $anchorExtraAttr .= ' dzstooltip-con';
//    print_rr(print_r($margs, true) . '$margs[\'style\'] - ' . !!($margs['style']));
  }


  $anchorExtraAttr .= ' ' . $margs['extra_classes'];

  $anchorExtraAttr .= '"';
  $anchorExtraAttr .= ' style="';

  if ($margs['color']) {
    $anchorExtraAttr .= 'color: ' . $margs['color'] . ';';
  }

  $anchorExtraAttr .= '"';


//        print_rr($margs);

  if ($margs['post_id']) {

    $anchorExtraAttr .= ' data-post_id="' . $margs['post_id'] . '"';


    if (strpos($margs['extra_classes'], 'dzsap-wishlist-but') !== false) {


      $arr_wishlist = $dzsap->classView->get_wishlist();


//		        print_rr($arr_wishlist);
      if (in_array($margs['post_id'], $arr_wishlist)) {


        $margs['icon'] = str_replace('fa-star-o', 'fa-star', $margs['icon']);
      }

    }


    $margs['extraattr'] = str_replace('{{posturl}}', get_permalink($margs['post_id']), $margs['extraattr']);
  }

  $anchorExtraAttr .= ' ' . $margs['extraattr'];


  $fout .= '<' . $startDomTag;


  $fout .= $anchorExtraAttr;

  $fout .= '>';


  if ($margs['wrap_object'] == 'on' && $margs['link']) {

//    $fout .= 'ceva';
    $fout .= ' <a rel="nofollow" href="' . $margs['link'] . '" ' . $anchorExtraAttr . '>';
  }

  if ($margs['style'] == 'player-but') {
    $fout .= '<span class="the-icon-bg';

//      print_rr($margs);
    if (strpos($margs['extra_classes'], 'dzsap-btn-info') !== false) {
      $fout .= ' tooltip-indicator';
    }

    $fout .= '"></span>';
  }
  if ($margs['style'] == 'btn-zoomsounds') {
    $fout .= '<span class="the-bg" style="';

    if ($margs['background_color']) {
      $fout .= 'background-color: ' . $margs['background_color'] . ';';
    }

    $fout .= '"></span>';
  }

  if (strpos($margs['icon'], 'fa-') !== false) {
    wp_enqueue_style('fontawesome', 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css');
  }

  if ($margs['style'] == 'player-but') {
    $fout .= '<i class="svg-icon';


    if (strpos($margs['extra_classes'], 'dzsap-btn-info') !== false) {
      $fout .= ' tooltip-indicator';
    }

    $fout .= ' fa ' . $margs['icon'] . '"></i>';
  }
  if ($margs['style'] == 'btn-zoomsounds') {
    $fout .= '<span class="the-icon"><i class="fa ' . $margs['icon'] . '"></i></span>';
//            $fout.='<i class="svg-icon fa '. $margs['icon'].'"></i>';
  }


  if ($margs['style'] == 'btn-zoomsounds') {
    $fout .= '<span class="the-label ">' . $margs['label'] . '</span>';
  }


  if ($margs['style'] == 'player-but') {

    $tooltip_class = 'dzstooltip arrow-from-start transition-slidein arrow-bottom skin-black align-right talign-end style-rounded color-dark-light';
    $fout .= '<span class="' . $tooltip_class . '" style="width: auto; white-space: nowrap;"><span class="dzstooltip--inner" style="margin-right: -10px;">' . $margs['label'] . '</span></span>';
  }


  if ($margs['wrap_object'] == 'on' && $margs['link']) {

    $fout .= '</a>';
  }
  $fout .= '</' . $startDomTag . '>';

  // <a rel="nofollow" href="#" class=" btn-zoomsounds  " style="color: #FFF;"><span class="the-bg" style="background-color: #00aced;"></span> <span class="the-label ">Twitter</span></a>
//  error_log('$fout --> '.$fout);


  return $fout;

}


function dzsap_shortcode_lightbox($atts, $content = null) {

  global $dzsap;
  $fout = '';
  //$dzsap->sliders_index++;

  $dzsap->front_scripts();

  DZSZoomSoundsHelper::enqueueUltibox();

  $args = array(
    'id' => 'default'
  , 'db' => ''
  , 'category' => ''
  , 'width' => ''
  , 'height' => ''
  , 'gallerywidth' => '800'
  , 'galleryheight' => '370'
  );
  $args = array_merge($args, $atts);
  $fout .= '<div class="ultibox"';

  if ($args['width'] != '') {
    $fout .= ' data-width="' . $args['width'] . '"';
  }
  if ($args['height'] != '') {
    $fout .= ' data-height="' . $args['height'] . '"';
  }
  if ($args['gallerywidth'] != '') {
    $fout .= ' data-bigwidth="' . $args['gallerywidth'] . '"';
  }
  if ($args['galleryheight'] != '') {
    $fout .= ' data-bigheight="' . $args['galleryheight'] . '"';
  }

  $fout .= 'data-src="' . DZSAP_BASE_URL . 'inc/php/retriever.php?id=' . $args['id'] . '" data-type="ajax">' . $content . '</div>';
  $fout .= '<script>
jQuery(document).ready(function($){
$(".zoombox").zoomBox();
});
</script>';

  return $fout;
}


/**
 *   [zoomsounds_showcase feed_from="audio_items" ids="1,2,3"]
 * , example2 : [zoomsounds_showcase feed_from="audio_items" ids="" style="widget_player" orderby="likes"  order="DESC" count="5" style_widget_player_show_likes="on"]
 * @param array $pargs
 * @return string
 */
function dzsap_shortcode_showcase($pargs = array()) {

  global $dzsapp, $dzsap;

  $fout = '';


  include(DZSAP_BASE_PATH . "class_parts/front_shortcode_showcase.php");


  if (defined('DZSAPP_BASE_URL')) {


    wp_enqueue_style('dzsapp_showcase', DZSAPP_BASE_URL . 'libs/dzsapp/front-dzsapp.css');
    wp_enqueue_script('dzsapp_showcase', DZSAPP_BASE_URL . 'libs/dzsapp/front-dzsapp.js');
  }

  return $fout;

}

function dzsap_shortcode_wishlist($pargs = array()) {

  global $dzsap;

  $margs = array();


  if (!is_array($pargs)) {
    $pargs = array();
  }


  $arr_wishlist = $dzsap->classView->get_wishlist();


//		print_rr($arr_wishlist);


  $fout = '';
  $fout .= '<div class="dzsap-wishlist">';


  if (get_current_user_id()) {

    foreach ($arr_wishlist as $pl) {


      $fout .= $dzsap->classView->shortcode_player(array(
        'source' => $pl,
        'called_from' => 'shortcode_wishlist',
        'config' => 'wishlist-player',
      ));
    }
  } else {
    $fout .= '<div class="dzsap-warning warning">' . esc_html__("You need to be logged in to have a wishlist.") . '</div>';
  }

  $fout .= '</div>';

  return $fout;
}

/** [dzsap_search_con]
 * @param array $pargs
 * @return string
 */
function dzsap_shortcode_search_con($pargs = array()) {

  // --

  $margs = array(
    'extra_classes' => 'search-align-right',
  );

  if (!is_array($pargs)) {
    $pargs = array();
  }

  $margs = array_merge($margs, $pargs);


  $fout = '';

  $fout .= '<div class="zoomsounds-search-con ' . $margs['extra_classes'] . '">';
  $fout .= dzsap_shortcode_dzsap_search($margs);
  $fout .= '</div>';

  return $fout;
}

/**
 * [dzsap_search]
 * @param array $pargs
 * @return string
 */
function dzsap_shortcode_dzsap_search($pargs = array()) {

  $margs = array(
    'extra_classes' => '',
    'target' => '',
  );

  if (!is_array($pargs)) {
    $pargs = array();
  }


  $margs = array_merge($margs, $pargs);


  $fout = '';

  $fout .= '<input class="zoomsounds-search-field ' . $margs['extra_classes'] . '" placeholder="' . esc_html__('Search tracks...', 'dzsap') . '"/>';

  return $fout;
}

