<?php
    
    namespace ElementPack\Modules\Carousel\Widgets;
    
    use ElementPack\Base\Module_Base;
    use Elementor\Controls_Manager;
    use Elementor\Group_Control_Image_Size;
    use Elementor\Group_Control_Border;
    use Elementor\Group_Control_Typography;
    use Elementor\Group_Control_Box_Shadow;
    use Elementor\Group_Control_Text_Shadow;
    use Elementor\Group_Control_Background;
    use Elementor\Icons_Manager;
    use ElementPack\Utils;
    
    use ElementPack\Modules\QueryControl\Controls\Group_Control_Posts;
    use ElementPack\Modules\QueryControl\Module;
    
    use ElementPack\Modules\Carousel\Skins;
    
    if ( !defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    
    class Carousel extends Module_Base {
        
        private $_query = null;
        
        public function get_name() {
            return 'bdt-carousel';
        }
        
        public function get_title() {
            return BDTEP . __( 'Carousel', 'bdthemes-element-pack' );
        }
        
        public function get_icon() {
            return 'bdt-wi-carousel';
        }
        
        public function get_categories() {
            return ['element-pack'];
        }
        
        public function get_keywords() {
            return ['carousel', 'navigation'];
        }
        
        public function get_style_depends() {
            if ( $this->ep_is_edit_mode() ) {
                return ['ep-all-styles'];
            } else {
                return ['element-pack-font', 'ep-carousel'];
            }
        }
        
        public function get_script_depends() {
            return ['imagesloaded', 'bdt-uikit-icons'];
        }
        
        public function on_import( $element ) {
            if ( !get_post_type_object( $element['settings']['posts_post_type'] ) ) {
                $element['settings']['posts_post_type'] = 'post';
            }
            
            return $element;
        }
        
        public function on_export( $element ) {
            $element = Group_Control_Posts::on_export_remove_setting_from_element( $element, 'posts' );
            return $element;
        }
        
        public function get_query() {
            return $this->_query;
        }
        
        public function _register_skins() {
            $this->add_skin( new Skins\Skin_Vertical( $this ) );
            $this->add_skin( new Skins\Skin_Alice( $this ) );
            $this->add_skin( new Skins\Skin_Ramble( $this ) );
        }
        
        public function get_custom_help_url() {
            return 'https://youtu.be/biF3GtBf0qc';
        }
        
        protected function _register_controls() {
            $this->register_query_section_controls();
        }
        
        private function register_query_section_controls() {
            $this->start_controls_section(
                'section_carousel_layout',
                [
                    'label' => __( 'Layout', 'bdthemes-element-pack' ),
                ]
            );
            
            $this->add_responsive_control(
                'columns',
                [
                    'label'          => __( 'Columns', 'bdthemes-element-pack' ),
                    'type'           => Controls_Manager::SELECT,
                    'default'        => 3,
                    'tablet_default' => 2,
                    'mobile_default' => 1,
                    'options'        => [
                        1 => '1',
                        2 => '2',
                        3 => '3',
                        4 => '4',
                        5 => '5',
                        6 => '6',
                    ],
                ]
            );
            
            $this->add_control(
                'posts_per_page',
                [
                    'label'   => __( 'Limit', 'bdthemes-element-pack' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 6,
                ]
            );
            
            $this->add_control(
                'item_gap',
                [
                    'label'   => __( 'Item Gap', 'bdthemes-element-pack' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 35,
                    ],
                    'range'   => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_layout_image',
                [
                    'label' => __( 'Image', 'bdthemes-element-pack' ),
                ]
            );
            
            $this->add_control(
                'thumbnail_show',
                [
                    'label'   => __( 'Thumbnail Show', 'bdthemes-element-pack' ),
                    'type'    => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                ]
            );
            
            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'         => 'thumbnail_size',
                    'label'        => __( 'Thumbnail Size', 'bdthemes-element-pack' ),
                    'exclude'      => ['custom'],
                    'default'      => 'medium',
                    'prefix_class' => 'bdt-carousel-thumbnail-size-',
                    'condition'    => [
                        'thumbnail_show' => 'yes',
                    ],
                ]
            );
            
            $this->add_control(
                'show_link_option',
                [
                    'label'     => __( 'Thumbnail Show Link?', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SWITCHER,
                    'default'   => 'yes',
                    'condition' => [
                        'thumbnail_show' => 'yes',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'image_width',
                [
                    'label'          => __( 'Image Width', 'bdthemes-element-pack' ),
                    'type'           => Controls_Manager::SLIDER,
                    'default'        => [
                        'size' => 100,
                        'unit' => '%',
                    ],
                    'tablet_default' => [
                        'unit' => '%',
                    ],
                    'mobile_default' => [
                        'unit' => '%',
                    ],
                    'size_units'     => ['%'],
                    'range'          => [
                        '%' => [
                            'min' => 5,
                            'max' => 100,
                        ],
                    ],
                    'selectors'      => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail' => 'width: {{SIZE}}{{UNIT}};margin-left: auto;margin-right: auto;',
                    ],
                    'condition'      => [
                        'thumbnail_show' => 'yes',
                        '_skin'          => '',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'alice_background_height',
                [
                    'label'          => __( 'Height(px)', 'bdthemes-element-pack' ),
                    'type'           => Controls_Manager::SLIDER,
                    'tablet_default' => [
                        'unit' => 'px',
                    ],
                    'mobile_default' => [
                        'unit' => 'px',
                    ],
                    'size_units'     => ['px'],
                    'range'          => [
                        'px' => [
                            'min' => 100,
                            'max' => 350,
                        ],
                    ],
                    'selectors'      => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-item .bdt-carousel-background' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition'      => [
                        'thumbnail_show' => '',
                        '_skin'          => 'bdt-alice',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'vertical_layout_image_width',
                [
                    'label'          => __( 'Image Width', 'bdthemes-element-pack' ),
                    'type'           => Controls_Manager::SLIDER,
                    'default'        => [
                        'size' => 50,
                        'unit' => '%',
                    ],
                    'tablet_default' => [
                        'unit' => '%',
                    ],
                    'mobile_default' => [
                        'unit' => '%',
                    ],
                    'size_units'     => ['%'],
                    'range'          => [
                        '%' => [
                            'min' => 5,
                            'max' => 100,
                        ],
                    ],
                    'selectors'      => [
                        '{{WRAPPER}} .bdt-carousel .bdt-grid .bdt-width-1-2' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition'      => [
                        'thumbnail_show' => 'yes',
                        '_skin'          => 'bdt-vertical',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'image_ratio',
                [
                    'label'     => __( 'Image Ratio', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'min'  => 0.1,
                            'max'  => 2,
                            'step' => 0.01,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail'       => 'padding-bottom: calc( {{SIZE}} * 100% ); top: 0; left: 0; right: 0; bottom: 0;',
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail:after' => 'content: "{{SIZE}}"; position: absolute; color: transparent;',
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail img'   => 'height: 100%; width: auto; position: absolute; top: 50%; left: 50%; transform: translate(-50%,-50%); font-size: {{SIZE}};',
                    ],
                    'condition' => [
                        'thumbnail_show' => 'yes',
                        '_skin!'         => 'bdt-ramble',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'ramble_image_ratio',
                [
                    'label'     => __( 'Image Ratio', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'min'  => 0.1,
                            'max'  => 2,
                            'step' => 0.01,
                        ],
                    ],
                    'default'   => [
                        'size' => 1,
                        'unit' => 'px',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail'       => 'padding-bottom: calc( {{SIZE}} * 100% ); top: 0; left: 0; right: 0; bottom: 0;',
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail:after' => 'content: "{{SIZE}}"; position: absolute; color: transparent;',
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail img'   => 'height: 100%; width: auto; position: absolute; top: 50%; left: 50%; transform: translate(-50%,-50%); font-size: {{SIZE}};',
                    ],
                    'condition' => [
                        'thumbnail_show' => 'yes',
                        '_skin'          => 'bdt-ramble',
                    ],
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_layout_title',
                [
                    'label' => __( 'Title', 'bdthemes-element-pack' ),
                ]
            );
            
            $this->add_control(
                'show_title',
                [
                    'label'   => __( 'Show Title', 'bdthemes-element-pack' ),
                    'type'    => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                ]
            );
            
            $this->add_control(
                'title_tag',
                [
                    'label'     => __( 'Title HTML Tag', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SELECT,
                    'options'   => element_pack_title_tags(),
                    'default'   => 'h4',
                    'condition' => [
                        'show_title' => 'yes',
                    ],
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_layout_meta',
                [
                    'label' => __( 'Meta', 'bdthemes-element-pack' ),
                
                ]
            );
            
            $this->add_control(
                'show_alice_category',
                [
                    'label'     => __( 'Category', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SWITCHER,
                    'default'   => 'yes',
                    'condition' => [
                        '_skin' => 'bdt-alice'
                    ],
                ]
            );
            
            $this->add_control(
                'meta_data',
                [
                    'label'       => __( 'Meta Data', 'bdthemes-element-pack' ),
                    'label_block' => true,
                    'type'        => Controls_Manager::SELECT2,
                    'default'     => ['date', 'comments'],
                    'multiple'    => true,
                    'options'     => [
                        'author'   => __( 'Author', 'bdthemes-element-pack' ),
                        'category' => __( 'Category', 'bdthemes-element-pack' ),
                        'date'     => __( 'Date', 'bdthemes-element-pack' ),
                        'time'     => __( 'Time', 'bdthemes-element-pack' ),
                        'comments' => __( 'Comments', 'bdthemes-element-pack' ),
                    ],
                    'condition'   => [
                        '_skin!' => 'bdt-alice'
                    ],
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_layout_excerpt',
                [
                    'label'     => __( 'Text', 'bdthemes-element-pack' ),
                    'condition' => [
                        '_skin!' => 'bdt-alice'
                    ],
                ]
            );
            
            $this->add_control(
                'show_excerpt',
                [
                    'label'   => __( 'Show Text', 'bdthemes-element-pack' ),
                    'type'    => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                ]
            );
            
            $this->add_control(
                'excerpt_length',
                [
                    'label'       => __( 'Text Limit', 'bdthemes-element-pack' ),
                    'description' => esc_html__( 'It\'s just work for main content, but not working with excerpt. If you set 0 so you will get full main content.', 'bdthemes-element-pack' ),
                    'type'        => Controls_Manager::NUMBER,
                    'default'     => 15,
                    'condition'   => [
                        'show_excerpt' => 'yes',
                    ],
                ]
            );
            
            $this->add_control(
                'strip_shortcode',
                [
                    'label'     => esc_html__( 'Strip Shortcode', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SWITCHER,
                    'default'   => 'yes',
                    'condition' => [
                        'show_excerpt' => 'yes',
                    ],
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_layout_button',
                [
                    'label'     => __( 'Readmore Button', 'bdthemes-element-pack' ),
                    'condition' => [
                        '_skin!' => 'bdt-alice'
                    ],
                ]
            );
            
            $this->add_control(
                'show_read_more',
                [
                    'label'   => __( 'Read More', 'bdthemes-element-pack' ),
                    'type'    => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                ]
            );
            
            $this->add_control(
                'read_more_text',
                [
                    'label'       => __( 'Read More Text', 'bdthemes-element-pack' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __( 'Read More', 'bdthemes-element-pack' ),
                    'placeholder' => __( 'Read More', 'bdthemes-element-pack' ),
                    'condition'   => [
                        'show_read_more' => 'yes',
                    ],
                ]
            );
            
            $this->add_control(
                'button_size',
                [
                    'label'     => __( 'Button Size', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SELECT,
                    'default'   => 'sm',
                    'options'   => [
                        'xs' => __( 'Extra Small', 'bdthemes-element-pack' ),
                        'sm' => __( 'Small', 'bdthemes-element-pack' ),
                        'md' => __( 'Medium', 'bdthemes-element-pack' ),
                        'lg' => __( 'Large', 'bdthemes-element-pack' ),
                        'xl' => __( 'Extra Large', 'bdthemes-element-pack' ),
                    ],
                    'condition' => [
                        'read_more_text!' => '',
                        'show_read_more!' => '',
                    ],
                ]
            );
            
            $this->add_control(
                'carousel_icon',
                [
                    'label'            => esc_html__( 'Button Icon', 'bdthemes-element-pack' ),
                    'type'             => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'condition'        => [
                        'read_more_text!' => '',
                        'show_read_more!' => '',
                    ],
                    'label_block' => false,
				    'skin' => 'inline'
                ]
            );
            
            $this->add_control(
                'icon_align',
                [
                    'label'     => esc_html__( 'Icon Position', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SELECT,
                    'default'   => 'right',
                    'options'   => [
                        'left'  => esc_html__( 'Left', 'bdthemes-element-pack' ),
                        'right' => esc_html__( 'Right', 'bdthemes-element-pack' ),
                    ],
                    'condition' => [
                        'carousel_icon[value]!' => '',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'icon_indent',
                [
                    'label'     => esc_html__( 'Icon Spacing', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'default'   => [
                        'size' => 8,
                    ],
                    'range'     => [
                        'px' => [
                            'max' => 50,
                        ],
                    ],
                    'condition' => [
                        'carousel_icon[value]!' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-flex-align-right' => is_rtl() ? 'margin-right: {{SIZE}}{{UNIT}};' : 'margin-left: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .bdt-carousel .bdt-flex-align-left'  => is_rtl() ? 'margin-left: {{SIZE}}{{UNIT}};' : 'margin-right: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_query',
                [
                    'label' => __( 'Query', 'bdthemes-element-pack' ),
                    'tab'   => Controls_Manager::TAB_CONTENT,
                ]
            );
            
            $this->add_group_control(
                Group_Control_Posts::get_type(),
                [
                    'name'  => 'posts',
                    'label' => __( 'Posts', 'bdthemes-element-pack' ),
                ]
            );
            
            $this->add_control(
                'advanced',
                [
                    'label' => __( 'Advanced', 'bdthemes-element-pack' ),
                    'type'  => Controls_Manager::HEADING,
                ]
            );
            
            $this->add_control(
                'orderby',
                [
                    'label'   => __( 'Order By', 'bdthemes-element-pack' ),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'post_date',
                    'options' => [
                        'post_date'  => __( 'Date', 'bdthemes-element-pack' ),
                        'post_title' => __( 'Title', 'bdthemes-element-pack' ),
                        'menu_order' => __( 'Menu Order', 'bdthemes-element-pack' ),
                        'rand'       => __( 'Random', 'bdthemes-element-pack' ),
                    ],
                ]
            );
            
            $this->add_control(
                'order',
                [
                    'label'   => __( 'Order', 'bdthemes-element-pack' ),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'desc',
                    'options' => [
                        'asc'  => __( 'ASC', 'bdthemes-element-pack' ),
                        'desc' => __( 'DESC', 'bdthemes-element-pack' ),
                    ],
                ]
            );
            
            
            $this->add_control(
                'offset',
                [
                    'label'     => esc_html__( 'Offset', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::NUMBER,
                    'default'   => 0,
                    'condition' => [
                        'posts_post_type!' => 'by_id',
                    ],
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_content_navigation',
                [
                    'label' => __( 'Navigation', 'bdthemes-element-pack' ),
                ]
            );
            
            $this->add_control(
                'navigation',
                [
                    'label'        => __( 'Navigation', 'bdthemes-element-pack' ),
                    'type'         => Controls_Manager::SELECT,
                    'default'      => 'arrows',
                    'options'      => [
                        'both'            => esc_html__( 'Arrows and Dots', 'bdthemes-element-pack' ),
                        'arrows-fraction' => esc_html__( 'Arrows and Fraction', 'bdthemes-element-pack' ),
                        'arrows'          => esc_html__( 'Arrows', 'bdthemes-element-pack' ),
                        'dots'            => esc_html__( 'Dots', 'bdthemes-element-pack' ),
                        'progressbar'     => esc_html__( 'Progress', 'bdthemes-element-pack' ),
                        'none'            => esc_html__( 'None', 'bdthemes-element-pack' ),
                    ],
                    'prefix_class' => 'bdt-navigation-type-',
                    'render_type'  => 'template',
                ]
            );
            
            $this->add_control(
                'dynamic_bullets',
                [
                    'label'     => __( 'Dynamic Bullets?', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SWITCHER,
                    'condition' => [
                        'navigation' => ['dots', 'both'],
                    ],
                ]
            );
            
            $this->add_control(
                'show_scrollbar',
                [
                    'label' => __( 'Show Scrollbar?', 'bdthemes-element-pack' ),
                    'type'  => Controls_Manager::SWITCHER,
                ]
            );
            
            $this->add_control(
                'both_position',
                [
                    'label'     => __( 'Arrows and Dots Position', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SELECT,
                    'default'   => 'center',
                    'options'   => element_pack_navigation_position(),
                    'condition' => [
                        'navigation' => 'both',
                    ],
                
                ]
            );
            
            $this->add_control(
                'arrows_fraction_position',
                [
                    'label'     => __( 'Arrows and Fraction Position', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SELECT,
                    'default'   => 'center',
                    'options'   => element_pack_navigation_position(),
                    'condition' => [
                        'navigation' => 'arrows-fraction',
                    ],
                
                ]
            );
            
            $this->add_control(
                'arrows_position',
                [
                    'label'     => __( 'Arrows Position', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SELECT,
                    'default'   => 'center',
                    'options'   => element_pack_navigation_position(),
                    'condition' => [
                        'navigation' => 'arrows',
                    ],
                
                ]
            );
            
            $this->add_control(
                'dots_position',
                [
                    'label'     => __( 'Dots Position', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SELECT,
                    'default'   => 'bottom-center',
                    'options'   => element_pack_pagination_position(),
                    'condition' => [
                        'navigation' => 'dots',
                    ],
                
                ]
            );
            
            $this->add_control(
                'progress_position',
                [
                    'label'     => __( 'Progress Position', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SELECT,
                    'default'   => 'bottom',
                    'options'   => [
                        'bottom' => esc_html__( 'Bottom', 'bdthemes-element-pack' ),
                        'top'    => esc_html__( 'Top', 'bdthemes-element-pack' ),
                    ],
                    'condition' => [
                        'navigation' => 'progressbar',
                    ],
                
                ]
            );
            
            $this->add_control(
                'nav_arrows_icon',
                [
                    'label'     => esc_html__( 'Arrows Icon', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SELECT,
                    'default'   => '5',
                    'options'   => [
                        '1'        => esc_html__( 'Style 1', 'bdthemes-element-pack' ),
                        '2'        => esc_html__( 'Style 2', 'bdthemes-element-pack' ),
                        '3'        => esc_html__( 'Style 3', 'bdthemes-element-pack' ),
                        '4'        => esc_html__( 'Style 4', 'bdthemes-element-pack' ),
                        '5'        => esc_html__( 'Style 5', 'bdthemes-element-pack' ),
                        '6'        => esc_html__( 'Style 6', 'bdthemes-element-pack' ),
                        '7'        => esc_html__( 'Style 7', 'bdthemes-element-pack' ),
                        '8'        => esc_html__( 'Style 8', 'bdthemes-element-pack' ),
                        '9'        => esc_html__( 'Style 9', 'bdthemes-element-pack' ),
                        '10'       => esc_html__( 'Style 10', 'bdthemes-element-pack' ),
                        '11'       => esc_html__( 'Style 11', 'bdthemes-element-pack' ),
                        '12'       => esc_html__( 'Style 12', 'bdthemes-element-pack' ),
                        '13'       => esc_html__( 'Style 13', 'bdthemes-element-pack' ),
                        '14'       => esc_html__( 'Style 14', 'bdthemes-element-pack' ),
                        '15'       => esc_html__( 'Style 15', 'bdthemes-element-pack' ),
                        '16'       => esc_html__( 'Style 16', 'bdthemes-element-pack' ),
                        '17'       => esc_html__( 'Style 17', 'bdthemes-element-pack' ),
                        '18'       => esc_html__( 'Style 18', 'bdthemes-element-pack' ),
                        'circle-1' => esc_html__( 'Style 19', 'bdthemes-element-pack' ),
                        'circle-2' => esc_html__( 'Style 20', 'bdthemes-element-pack' ),
                        'circle-3' => esc_html__( 'Style 21', 'bdthemes-element-pack' ),
                        'circle-4' => esc_html__( 'Style 22', 'bdthemes-element-pack' ),
                        'square-1' => esc_html__( 'Style 23', 'bdthemes-element-pack' ),
                    ],
                    'condition' => [
                        'navigation' => ['arrows-fraction', 'both', 'arrows'],
                    ],
                ]
            );
            
            $this->add_control(
                'hide_arrow_on_mobile',
                [
                    'label'     => __( 'Hide Arrow on Mobile', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SWITCHER,
                    'default'   => 'yes',
                    'condition' => [
                        'navigation' => ['arrows-fraction', 'arrows', 'both'],
                    ],
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_carousel_settings',
                [
                    'label' => __( 'Carousel Settings', 'bdthemes-element-pack' ),
                ]
            );
            
            $this->add_control(
                'skin',
                [
                    'label'        => esc_html__( 'Layout', 'bdthemes-element-pack' ),
                    'type'         => Controls_Manager::SELECT,
                    'default'      => 'carousel',
                    'options'      => [
                        'carousel'  => esc_html__( 'Carousel', 'bdthemes-element-pack' ),
                        'coverflow' => esc_html__( 'Coverflow', 'bdthemes-element-pack' ),
                    ],
                    'prefix_class' => 'bdt-carousel-style-',
                    'render_type'  => 'template',
                ]
            );
            
            $this->add_control(
                'coverflow_toggle',
                [
                    'label'        => __( 'Coverflow Effect', 'bdthemes-element-pack' ),
                    'type'         => Controls_Manager::POPOVER_TOGGLE,
                    'return_value' => 'yes',
                    'condition'    => [
                        'skin' => 'coverflow'
                    ]
                ]
            );
            
            $this->start_popover();
            
            $this->add_control(
                'coverflow_rotate',
                [
                    'label'       => esc_html__( 'Rotate', 'bdthemes-element-pack' ),
                    'type'        => Controls_Manager::SLIDER,
                    'default'     => [
                        'size' => 50,
                    ],
                    'range'       => [
                        'px' => [
                            'min'  => -360,
                            'max'  => 360,
                            'step' => 5,
                        ],
                    ],
                    'condition'   => [
                        'coverflow_toggle' => 'yes'
                    ],
                    'render_type' => 'template',
                ]
            );
            
            $this->add_control(
                'coverflow_stretch',
                [
                    'label'       => __( 'Stretch', 'bdthemes-element-pack' ),
                    'type'        => Controls_Manager::SLIDER,
                    'default'     => [
                        'size' => 0,
                    ],
                    'range'       => [
                        'px' => [
                            'min'  => 0,
                            'step' => 10,
                            'max'  => 100,
                        ],
                    ],
                    'condition'   => [
                        'coverflow_toggle' => 'yes'
                    ],
                    'render_type' => 'template',
                ]
            );
            
            $this->add_control(
                'coverflow_modifier',
                [
                    'label'       => __( 'Modifier', 'bdthemes-element-pack' ),
                    'type'        => Controls_Manager::SLIDER,
                    'default'     => [
                        'size' => 1,
                    ],
                    'range'       => [
                        'px' => [
                            'min'  => 1,
                            'step' => 1,
                            'max'  => 10,
                        ],
                    ],
                    'condition'   => [
                        'coverflow_toggle' => 'yes'
                    ],
                    'render_type' => 'template',
                ]
            );
            
            $this->add_control(
                'coverflow_depth',
                [
                    'label'       => __( 'Depth', 'bdthemes-element-pack' ),
                    'type'        => Controls_Manager::SLIDER,
                    'default'     => [
                        'size' => 100,
                    ],
                    'range'       => [
                        'px' => [
                            'min'  => 0,
                            'step' => 10,
                            'max'  => 1000,
                        ],
                    ],
                    'condition'   => [
                        'coverflow_toggle' => 'yes'
                    ],
                    'render_type' => 'template',
                ]
            );
            
            $this->end_popover();
            
            $this->add_control(
                'hr_005',
                [
                    'type'      => Controls_Manager::DIVIDER,
                    'condition' => [
                        'skin' => 'coverflow'
                    ]
                ]
            );
            
            $this->add_control(
                'match_height',
                [
                    'label' => __( 'Item Match Height', 'bdthemes-element-pack' ),
                    'type'  => Controls_Manager::SWITCHER,
                ]
            );
            
            $this->add_control(
                'autoplay',
                [
                    'label'   => __( 'Autoplay', 'bdthemes-element-pack' ),
                    'type'    => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                
                ]
            );
            
            $this->add_control(
                'autoplay_speed',
                [
                    'label'     => esc_html__( 'Autoplay Speed', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::NUMBER,
                    'default'   => 5000,
                    'condition' => [
                        'autoplay' => 'yes',
                    ],
                ]
            );
            
            $this->add_control(
                'pauseonhover',
                [
                    'label' => esc_html__( 'Pause on Hover', 'bdthemes-element-pack' ),
                    'type'  => Controls_Manager::SWITCHER,
                ]
            );
            
            $this->add_responsive_control(
                'slides_to_scroll',
                [
                    'type'           => Controls_Manager::SELECT,
                    'label'          => esc_html__( 'Slides to Scroll', 'bdthemes-element-pack' ),
                    'default'        => 1,
                    'tablet_default' => 1,
                    'mobile_default' => 1,
                    'options'        => [
                        1 => '1',
                        2 => '2',
                        3 => '3',
                        4 => '4',
                        5 => '5',
                        6 => '6',
                    ],
                ]
            );
            
            $this->add_control(
                'centered_slides',
                [
                    'label'       => __( 'Center Slide', 'bdthemes-element-pack' ),
                    'description' => __( 'Use even items from Layout > Columns settings for better preview.', 'bdthemes-element-pack' ),
                    'type'        => Controls_Manager::SWITCHER,
                ]
            );
            
            $this->add_control(
                'grab_cursor',
                [
                    'label' => __( 'Grab Cursor', 'bdthemes-element-pack' ),
                    'type'  => Controls_Manager::SWITCHER,
                ]
            );
            
            $this->add_control(
                'loop',
                [
                    'label'   => __( 'Loop', 'bdthemes-element-pack' ),
                    'type'    => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                
                ]
            );
            
            
            $this->add_control(
                'speed',
                [
                    'label'   => __( 'Animation Speed (ms)', 'bdthemes-element-pack' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 500,
                    ],
                    'range' => [
                        'px' => [
                            'min'  => 100,
                            'max'  => 5000,
                            'step' => 50,
                        ],
                    ],
                ]
            );
            
            $this->add_control(
                'observer',
                [
                    'label'       => __( 'Observer', 'bdthemes-element-pack' ),
                    'description' => __( 'When you use carousel in any hidden place (in tabs, accordion etc) keep it yes.', 'bdthemes-element-pack' ),
                    'type'        => Controls_Manager::SWITCHER,
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_style_skin',
                [
                    'label'     => __( 'Items', 'bdthemes-element-pack' ),
                    'tab'       => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        '_skin' => 'bdt-alice'
                    ],
                ]
            );
            
            $this->add_control(
                'skin_shadow_mode',
                [
                    'label'        => esc_html__( 'Shadow Mode', 'bdthemes-element-pack' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'prefix_class' => 'bdt-ep-shadow-mode-',
                ]
            );
            
            $this->add_control(
                'skin_shadow_color',
                [
                    'label'     => esc_html__( 'Shadow Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'condition' => [
                        'skin_shadow_mode' => 'yes',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .elementor-widget-container:before' => is_rtl() ? 'background: linear-gradient(to left, {{VALUE}} 5%,rgba(255,255,255,0) 100%);' : 'background: linear-gradient(to right, {{VALUE}} 5%,rgba(255,255,255,0) 100%);',
                        '{{WRAPPER}} .elementor-widget-container:after'  => is_rtl() ? 'background: linear-gradient(to left, rgba(255,255,255,0) 0%, {{VALUE}} 95%);' : 'background: linear-gradient(to right, rgba(255,255,255,0) 0%, {{VALUE}} 95%);',
                    ],
                ]
            );
            
            $this->add_control(
                'overlay_blur_effect',
                [
                    'label'       => esc_html__( 'Blur Effect', 'bdthemes-element-pack' ) . BDTEP_NC,
                    'type'        => Controls_Manager::SWITCHER,
                    'description' => sprintf( __( 'This feature will not work in the Firefox browser untill you enable browser compatibility so please %1s look here %2s', 'bdthemes-element-pack' ), '<a href="https://developer.mozilla.org/en-US/docs/Web/CSS/backdrop-filter#Browser_compatibility" target="_blank">', '</a>' ),
                    'condition'   => [
                        'thumbnail_show' => 'yes',
                    ],
                ]
            );
            
            $this->add_control(
                'overlay_blur_level',
                [
                    'label'     => __( 'Blur Level', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'min'  => 0,
                            'step' => 1,
                            'max'  => 50,
                        ]
                    ],
                    'default'   => [
                        'size' => 5
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-custom-overlay' => 'backdrop-filter: blur({{SIZE}}px); -webkit-backdrop-filter: blur({{SIZE}}px); opacity: 1;'
                    ],
                    'condition' => [
                        'overlay_blur_effect' => 'yes',
                        'thumbnail_show'      => 'yes',
                    ]
                ]
            );
            
            $this->add_control(
                'skin_overlay_color',
                [
                    'label'     => esc_html__( 'Overlay Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#000',
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-custom-overlay' => 'background: {{VALUE}};',
                    ],
                    'condition' => [
                        'thumbnail_show' => 'yes',
                    ],
                ]
            );
            
            $this->add_control(
                'skin_item_color',
                [
                    'label'     => esc_html__( 'Item Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-item .bdt-carousel-background' => 'background: {{VALUE}};',
                    ],
                    'condition' => [
                        'thumbnail_show' => '',
                    ],
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_style_layout',
                [
                    'label'     => __( 'Items', 'bdthemes-element-pack' ),
                    'tab'       => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        '_skin!' => 'bdt-alice'
                    ],
                ]
            );
            
            $this->add_control(
                'content_alignment',
                [
                    'label'     => esc_html__( 'Alignment', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::CHOOSE,
                    'options'   => [
                        'left'   => [
                            'title' => esc_html__( 'Left', 'bdthemes-element-pack' ),
                            'icon'  => 'fas fa-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'bdthemes-element-pack' ),
                            'icon'  => 'fas fa-align-center',
                        ],
                        'right'  => [
                            'title' => esc_html__( 'Right', 'bdthemes-element-pack' ),
                            'icon'  => 'fas fa-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-item .bdt-carousel-desc' => 'text-align: {{VALUE}}',
                    ],
                ]
            );
            
            $this->start_controls_tabs( 'tabs_item_style' );
            
            $this->start_controls_tab(
                'tab_item_normal',
                [
                    'label' => __( 'Normal', 'bdthemes-element-pack' ),
                ]
            );
            
            $this->add_control(
                'item_background',
                [
                    'label'     => __( 'Background', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '#fff',
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-item' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'     => 'item_shadow',
                    'selector' => '{{WRAPPER}} .bdt-carousel .bdt-carousel-item',
                ]
            );
            
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'        => 'item_border',
                    'label'       => __( 'Border', 'bdthemes-element-pack' ),
                    'placeholder' => '1px',
                    'default'     => '1px',
                    'selector'    => '{{WRAPPER}} .bdt-carousel .bdt-carousel-item',
                ]
            );
            
            $this->add_responsive_control(
                'item_border_radius',
                [
                    'label'      => __( 'Border Radius', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'item_padding',
                [
                    'label'      => __( 'Padding', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );
            
            $this->add_control(
                'shadow_mode',
                [
                    'label'        => esc_html__( 'Shadow Mode', 'bdthemes-element-pack' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'prefix_class' => 'bdt-ep-shadow-mode-',
                ]
            );
            
            $this->add_control(
                'shadow_color',
                [
                    'label'     => esc_html__( 'Shadow Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'condition' => [
                        'shadow_mode' => 'yes',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .elementor-widget-container:before' => is_rtl() ? 'background: linear-gradient(to left, {{VALUE}} 5%,rgba(255,255,255,0) 100%);' : 'background: linear-gradient(to right, {{VALUE}} 5%,rgba(255,255,255,0) 100%);',
                        '{{WRAPPER}} .elementor-widget-container:after'  => is_rtl() ? 'background: linear-gradient(to left, rgba(255,255,255,0) 0%, {{VALUE}} 95%);' : 'background: linear-gradient(to right, rgba(255,255,255,0) 0%, {{VALUE}} 95%);',
                    ],
                ]
            );
            
            $this->add_control(
                'item_opacity',
                [
                    'label'     => esc_html__( 'Opacity', 'bdthemes-element-pack' ) . BDTEP_NC,
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'min'  => 0,
                            'step' => 0.1,
                            'max'  => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-item' => 'opacity: {{SIZE}};',
                    ],
                ]
            );
            
            $this->end_controls_tab();
            
            $this->start_controls_tab(
                'tab_item_hover',
                [
                    'label' => __( 'Hover', 'bdthemes-element-pack' ),
                ]
            );
            
            $this->add_control(
                'item_hover_background',
                [
                    'label'     => __( 'Background', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-item:hover' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_control(
                'item_inner_hover_background',
                [
                    'label'     => __( 'Inner Background', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel-skin-ramble .bdt-carousel-item .bdt-carousel-desc' => 'background-color: {{VALUE}};',
                    ],
                    'condition' => [
                        '_skin' => 'bdt-ramble',
                    ],
                ]
            );
            
            $this->add_control(
                'item_hover_line_effect_color',
                [
                    'label'     => __( 'Inner Border Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-item .bdt-carousel-thumbnail:before' => 'border-color: {{VALUE}};',
                    ],
                    'condition' => [
                        '_skin' => 'bdt-ramble',
                    ],
                ]
            );
            
            $this->add_control(
                'item_hover_border_color',
                [
                    'label'     => __( 'Border Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'condition' => [
                        'item_border_border!' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-item:hover' => 'border-color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'     => 'item_hover_shadow',
                    'selector' => '{{WRAPPER}} .bdt-carousel .bdt-carousel-item:hover',
                ]
            );
            
            $this->add_responsive_control(
                'item_shadow_padding',
                [
                    'label'       => __( 'Match Padding', 'bdthemes-element-pack' ),
                    'description' => __( 'You have to add padding for matching overlaping normal/hover box shadow when you used Box Shadow option.', 'bdthemes-element-pack' ),
                    'type'        => Controls_Manager::SLIDER,
                    'range'       => [
                        'px' => [
                            'min'  => 0,
                            'step' => 1,
                            'max'  => 50,
                        ]
                    ],
                    'default'     => [
                        'size' => 10
                    ],
                    'selectors'   => [
                        '{{WRAPPER}} .swiper-container' => 'padding: {{SIZE}}{{UNIT}}; margin: 0 -{{SIZE}}{{UNIT}};'
                    ],
                ]
            );
            
            $this->add_control(
                'item_hover_opacity',
                [
                    'label'     => esc_html__( 'Opacity', 'bdthemes-element-pack' ) . BDTEP_NC,
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'min'  => 0,
                            'step' => 0.1,
                            'max'  => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-item:hover' => 'opacity: {{SIZE}};',
                    ],
                ]
            );
            
            $this->end_controls_tab();
            
            $this->start_controls_tab(
                'tab_item_active',
                [
                    'label' => __( 'Active', 'bdthemes-element-pack' ) . BDTEP_NC,
                ]
            );
            
            $this->add_control(
                'item_active_background',
                [
                    'label'     => __( 'Background', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-item.swiper-slide-active' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_control(
                'item_active_border_color',
                [
                    'label'     => __( 'Border Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'condition' => [
                        'item_border_border!' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-item.swiper-slide-active' => 'border-color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'     => 'item_active_shadow',
                    'selector' => '{{WRAPPER}} .bdt-carousel .bdt-carousel-item.swiper-slide-active',
                ]
            );
            
            $this->add_control(
                'item_active_opacity',
                [
                    'label'     => esc_html__( 'Opacity', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'min'  => 0,
                            'step' => 0.1,
                            'max'  => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-item.swiper-slide-active' => 'opacity: {{SIZE}};',
                    ],
                ]
            );
            
            $this->end_controls_tab();
            
            $this->end_controls_tabs();
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_style_image',
                [
                    'label'     => __( 'Image', 'bdthemes-element-pack' ),
                    'tab'       => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'thumbnail_show' => 'yes',
                    ],
                ]
            );
            
            $this->add_control(
                'image_background',
                [
                    'label'     => __( 'Background', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'image_padding',
                [
                    'label'      => __( 'Padding', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'image_margin',
                [
                    'label'      => __( 'Margin', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'image_border_radius',
                [
                    'label'      => __( 'Border Radius', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail'     => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                    ],
                ]
            );
            
            $this->add_control(
                'image_opacity',
                [
                    'label'     => __( 'Opacity (%)', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'default'   => [
                        'size' => 1,
                    ],
                    'range'     => [
                        'px' => [
                            'max'  => 1,
                            'min'  => 0.10,
                            'step' => 0.01,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail img' => 'opacity: {{SIZE}};',
                    ],
                ]
            );
            
            $this->add_control(
                'image_hover_opacity',
                [
                    'label'     => __( 'Hover Opacity (%)', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'default'   => [
                        'size' => 1,
                    ],
                    'range'     => [
                        'px' => [
                            'max'  => 1,
                            'min'  => 0.10,
                            'step' => 0.01,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail:hover img' => 'opacity: {{SIZE}};',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'image_spacing',
                [
                    'label'     => __( 'Spacing', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-thumbnail' => 'margin-bottom: {{SIZE}}{{UNIT}}',
                    ],
                    'default'   => [
                        'size' => 20,
                    ],
                    'condition' => [
                        '_skin' => '',
                    ],
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_style_categories',
                [
                    'label'     => __( 'Categories', 'bdthemes-element-pack' ),
                    'tab'       => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        '_skin' => 'bdt-alice',
                    ],
                ]
            );
            
            $this->add_control(
                'category_color',
                [
                    'label'     => __( 'Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-categories a' => 'color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_control(
                'category_background',
                [
                    'label'     => esc_html__( 'Background Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-categories a' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'        => 'category_border',
                    'label'       => esc_html__( 'Border', 'bdthemes-element-pack' ),
                    'placeholder' => '1px',
                    'default'     => '1px',
                    'selector'    => '{{WRAPPER}} .bdt-carousel .bdt-carousel-categories a',
                    'separator'   => 'before',
                ]
            );
            
            $this->add_responsive_control(
                'category_border_radius',
                [
                    'label'      => esc_html__( 'Border Radius', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-categories a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'     => 'category_shadow',
                    'selector' => '{{WRAPPER}} .bdt-carousel .bdt-carousel-categories a',
                ]
            );
            
            $this->add_responsive_control(
                'category_padding',
                [
                    'label'      => esc_html__( 'Padding', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-categories a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator'  => 'before',
                ]
            );
            
            $this->add_responsive_control(
                'category_spacing',
                [
                    'label'     => __( 'Spacing', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-categories a' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'category_typography',
                    'selector' => '{{WRAPPER}} .bdt-carousel .bdt-carousel-categories a',
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_style_title',
                [
                    'label'     => __( 'Title', 'bdthemes-element-pack' ),
                    'tab'       => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'show_title' => 'yes',
                    ],
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label'     => __( 'Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-title a' => 'color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_control(
                'title_hover_color',
                [
                    'label'     => __( 'Hover Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-title a:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Text_Shadow::get_type(),
                [
                    'name'     => 'title_shadow',
                    'label'    => __( 'Text Shadow', 'bdthemes-element-pack' ) . BDTEP_NC,
                    'selector' => '{{WRAPPER}} .bdt-carousel .bdt-carousel-title a',
                ]
            );
            
            $this->add_responsive_control(
                'title_spacing',
                [
                    'label'     => __( 'Spacing', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-title' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'selector' => '{{WRAPPER}} .bdt-carousel .bdt-carousel-title',
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_style_date',
                [
                    'label'     => __( 'Date', 'bdthemes-element-pack' ),
                    'tab'       => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        '_skin' => 'bdt-alice',
                    ],
                ]
            );
            
            $this->add_control(
                'date_color',
                [
                    'label'     => __( 'Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-date' => 'color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'date_spacing',
                [
                    'label'     => __( 'Spacing', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-date' => 'margin-top: {{SIZE}}{{UNIT}} !important;',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'date_typography',
                    'label'    => esc_html__( 'Typography', 'bdthemes-element-pack' ),
                    'selector' => '{{WRAPPER}} .bdt-carousel .bdt-carousel-date',
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_style_meta',
                [
                    'label'      => __( 'Meta', 'bdthemes-element-pack' ),
                    'tab'        => Controls_Manager::TAB_STYLE,
                    'conditions' => [
                        'terms' => [
                            [
                                'name'     => 'meta_data',
                                'operator' => '!=',
                                'value'    => '',
                            ],
                            [
                                'name'     => '_skin',
                                'operator' => '!=',
                                'value'    => 'bdt-alice',
                            ],
                        ],
                    ],
                ]
            );
            
            $this->add_control(
                'meta_color',
                [
                    'label'     => __( 'Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-meta span *' => 'color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_control(
                'meta_hover_color',
                [
                    'label'     => __( 'Hover Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-meta span:hover'   => 'color: {{VALUE}};',
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-meta span:hover a' => 'color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_control(
                'meta_divider_color',
                [
                    'label'     => __( 'Divider Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-meta span:after' => 'background: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'meta_spacing',
                [
                    'label'     => __( 'Spacing', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-meta' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'meta_typography',
                    'selector' => '{{WRAPPER}} .bdt-carousel .bdt-carousel-meta span',
                ]
            );
            
            $this->add_control(
                'meta_alignment',
                [
                    'label'     => esc_html__( 'Alignment', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::CHOOSE,
                    'options'   => [
                        'flex-start' => [
                            'title' => esc_html__( 'Left', 'bdthemes-element-pack' ),
                            'icon'  => 'fas fa-align-left',
                        ],
                        'center'     => [
                            'title' => esc_html__( 'Center', 'bdthemes-element-pack' ),
                            'icon'  => 'fas fa-align-center',
                        ],
                        'flex-end'   => [
                            'title' => esc_html__( 'Right', 'bdthemes-element-pack' ),
                            'icon'  => 'fas fa-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-meta' => 'justify-content: {{VALUE}}',
                    ],
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_style_excerpt',
                [
                    'label'      => __( 'Text', 'bdthemes-element-pack' ),
                    'tab'        => Controls_Manager::TAB_STYLE,
                    'condition'  => [
                        'show_excerpt' => 'yes',
                    ],
                    'conditions' => [
                        'terms' => [
                            [
                                'name'  => 'show_excerpt',
                                'value' => 'yes',
                            ],
                            [
                                'name'     => '_skin',
                                'operator' => '!=',
                                'value'    => 'bdt-alice',
                            ],
                        ],
                    ],
                ]
            );
            
            $this->add_control(
                'excerpt_color',
                [
                    'label'     => __( 'Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-excerpt' => 'color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'excerpt_spacing',
                [
                    'label'     => __( 'Spacing', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-excerpt' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'excerpt_typography',
                    'label'    => esc_html__( 'Typography', 'bdthemes-element-pack' ),
                    'selector' => '{{WRAPPER}} .bdt-carousel .bdt-carousel-excerpt',
                ]
            );
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_style_button',
                [
                    'label'      => __( 'Button', 'bdthemes-element-pack' ),
                    'tab'        => Controls_Manager::TAB_STYLE,
                    'conditions' => [
                        'terms' => [
                            [
                                'name'  => 'show_read_more',
                                'value' => 'yes',
                            ],
                            [
                                'name'     => 'read_more_text',
                                'operator' => '!=',
                                'value'    => '',
                            ],
                            [
                                'name'     => '_skin',
                                'operator' => '!=',
                                'value'    => 'bdt-alice',
                            ],
                        ],
                    ],
                ]
            );
            
            $this->start_controls_tabs( 'tabs_button_style' );
            
            $this->start_controls_tab(
                'tab_button_normal',
                [
                    'label' => esc_html__( 'Normal', 'bdthemes-element-pack' ),
                ]
            );
            
            $this->add_control(
                'button_text_color',
                [
                    'label'     => esc_html__( 'Text Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel-button' => 'color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name'     => 'button_background_color',
                    'selector' => '{{WRAPPER}} .bdt-carousel-button',
                ]
            );
            
            $this->add_group_control(
                Group_Control_Border::get_type(), [
                    'name'        => 'button_border',
                    'label'       => esc_html__( 'Border', 'bdthemes-element-pack' ),
                    'placeholder' => '1px',
                    'default'     => '1px',
                    'selector'    => '{{WRAPPER}} .bdt-carousel-button',
                ]
            );
            
            $this->add_responsive_control(
                'button_border_radius',
                [
                    'label'      => esc_html__( 'Border Radius', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'button_text_padding',
                [
                    'label'      => esc_html__( 'Padding', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'     => 'button_shadow',
                    'selector' => '{{WRAPPER}} .bdt-carousel-button',
                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'button_typography',
                    'selector' => '{{WRAPPER}} .bdt-carousel-button',
                ]
            );
            
            $this->add_control(
                'carousel_button_icon_color',
                [
                    'label'     => esc_html__( 'Icon Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-button .bdt-carousel-button-icon i'   => 'color: {{VALUE}};',
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-button .bdt-carousel-button-icon svg' => 'fill: {{VALUE}};',
                    ],
                    'condition' => [
                        'carousel_icon[value]!' => '',
                    ],
                    'separator' => 'before',
                ]
            );
            
            $this->add_responsive_control(
                'carousel_icon_size',
                [
                    'label'     => __( 'Icon Size', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'min' => 10,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-button .bdt-carousel-button-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'carousel_icon[value]!' => '',
                    ],
                ]
            );
            
            $this->end_controls_tab();
            
            $this->start_controls_tab(
                'tab_button_hover',
                [
                    'label' => esc_html__( 'Hover', 'bdthemes-element-pack' ),
                ]
            );
            
            $this->add_control(
                'button_hover_color',
                [
                    'label'     => esc_html__( 'Text Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel-button:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name'     => 'button_background_hover_color',
                    'selector' => '{{WRAPPER}} .bdt-carousel-button:hover',
                
                ]
            );
            
            $this->add_control(
                'button_hover_border_color',
                [
                    'label'     => esc_html__( 'Border Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'condition' => [
                        'button_border_border!' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel-button:hover' => 'border-color: {{VALUE}};',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'     => 'button_hover_shadow',
                    'selector' => '{{WRAPPER}} .bdt-carousel-button:hover',
                ]
            );
            
            $this->add_control(
                'button_hover_animation',
                [
                    'label' => esc_html__( 'Animation', 'bdthemes-element-pack' ),
                    'type'  => Controls_Manager::HOVER_ANIMATION,
                ]
            );
            
            $this->add_control(
                'carousel_button_hover_icon_color',
                [
                    'label'     => esc_html__( 'Icon Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-button:hover .bdt-carousel-button-icon i'   => 'color: {{VALUE}};',
                        '{{WRAPPER}} .bdt-carousel .bdt-carousel-button:hover .bdt-carousel-button-icon svg' => 'fill: {{VALUE}};',
                    ],
                    'condition' => [
                        'carousel_icon[value]!' => '',
                    ],
                    'separator' => 'before',
                ]
            );
            
            $this->end_controls_tab();
            
            $this->end_controls_tabs();
            
            $this->end_controls_section();
            
            $this->start_controls_section(
                'section_style_navigation',
                [
                    'label'      => __( 'Navigation', 'bdthemes-element-pack' ),
                    'tab'        => Controls_Manager::TAB_STYLE,
                    'conditions' => [
                        'relation' => 'or',
                        'terms'    => [
                            [
                                'name'     => 'navigation',
                                'operator' => '!=',
                                'value'    => 'none',
                            ],
                            [
                                'name'  => 'show_scrollbar',
                                'value' => 'yes',
                            ],
                        ],
                    ],
                ]
            );
            
            $this->add_control(
                'arrows_heading',
                [
                    'label'     => __( 'Arrows', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::HEADING,
                    'condition' => [
                        'navigation!' => ['dots', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->start_controls_tabs( 'tabs_navigation_arrows_style' );
            
            $this->start_controls_tab(
                'tabs_nav_arrows_normal',
                [
                    'label'     => __( 'Normal', 'bdthemes-element-pack' ),
                    'condition' => [
                        'navigation!' => ['dots', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_control(
                'arrows_color',
                [
                    'label'     => __( 'Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-prev i, {{WRAPPER}} .bdt-carousel .bdt-navigation-next i' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'navigation!' => ['dots', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_control(
                'arrows_background',
                [
                    'label'     => __( 'Background', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-prev, {{WRAPPER}} .bdt-carousel .bdt-navigation-next' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'navigation!' => ['dots', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'      => 'nav_arrows_border',
                    'selector'  => '{{WRAPPER}} .bdt-carousel .bdt-navigation-prev, {{WRAPPER}} .bdt-carousel .bdt-navigation-next',
                    'condition' => [
                        'navigation!' => ['dots', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'border_radius',
                [
                    'label'      => __( 'Border Radius', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-prev, {{WRAPPER}} .bdt-carousel .bdt-navigation-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition'  => [
                        'navigation!' => ['dots', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'arrows_padding',
                [
                    'label'      => esc_html__( 'Padding', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-prev, {{WRAPPER}} .bdt-carousel .bdt-navigation-next' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition'  => [
                        'navigation!' => ['dots', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'arrows_size',
                [
                    'label'     => __( 'Size', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'min' => 10,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-prev i,
					{{WRAPPER}} .bdt-carousel .bdt-navigation-next i' => 'font-size: {{SIZE || 24}}{{UNIT}};',
                    ],
                    'condition' => [
                        'navigation!' => ['dots', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'arrows_space',
                [
                    'label'     => __( 'Space Between Arrows', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-prev' => 'margin-right: {{SIZE}}px;',
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-next' => 'margin-left: {{SIZE}}px;',
                    ],
                    'condition' => [
                        'navigation!' => ['dots', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->end_controls_tab();
            
            $this->start_controls_tab(
                'tabs_nav_arrows_hover',
                [
                    'label'     => __( 'Hover', 'bdthemes-element-pack' ),
                    'condition' => [
                        'navigation!' => ['dots', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_control(
                'arrows_hover_color',
                [
                    'label'     => __( 'Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-prev:hover i, {{WRAPPER}} .bdt-carousel .bdt-navigation-next:hover i' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'navigation!' => ['dots', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_control(
                'arrows_hover_background',
                [
                    'label'     => __( 'Background', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-prev:hover, {{WRAPPER}} .bdt-carousel .bdt-navigation-next:hover' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'navigation!' => ['dots', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_control(
                'nav_arrows_hover_border_color',
                [
                    'label'     => __( 'Border Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-prev:hover, {{WRAPPER}} .bdt-carousel .bdt-navigation-next:hover' => 'border-color: {{VALUE}};',
                    ],
                    'condition' => [
                        'nav_arrows_border_border!' => '',
                        'navigation!'               => ['dots', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->end_controls_tab();
            
            $this->end_controls_tabs();
            
            $this->add_control(
                'hr_1',
                [
                    'type'      => Controls_Manager::DIVIDER,
                    'condition' => [
                        'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_control(
                'dots_heading',
                [
                    'label'     => __( 'Dots', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::HEADING,
                    'condition' => [
                        'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_control(
                'hr_11',
                [
                    'type'      => Controls_Manager::DIVIDER,
                    'condition' => [
                        'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_control(
                'dots_color',
                [
                    'label'     => __( 'Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_control(
                'active_dot_color',
                [
                    'label'     => __( 'Active Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .swiper-pagination-bullet-active' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_control(
                'dots_size',
                [
                    'label'     => __( 'Size', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'min' => 5,
                            'max' => 20,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .swiper-pagination-bullet' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
                    ],
                ]
            );
            
            $this->add_control(
                'hr_2',
                [
                    'type'      => Controls_Manager::DIVIDER,
                    'condition' => [
                        'navigation' => 'arrows-fraction',
                    ],
                ]
            );
            
            $this->add_control(
                'fraction_heading',
                [
                    'label'     => __( 'Fraction', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::HEADING,
                    'condition' => [
                        'navigation' => 'arrows-fraction',
                    ],
                ]
            );
            
            $this->add_control(
                'hr_12',
                [
                    'type'      => Controls_Manager::DIVIDER,
                    'condition' => [
                        'navigation' => 'arrows-fraction',
                    ],
                ]
            );
            
            $this->add_control(
                'fraction_color',
                [
                    'label'     => __( 'Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .swiper-pagination-fraction' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'navigation' => 'arrows-fraction',
                    ],
                ]
            );
            
            $this->add_control(
                'active_fraction_color',
                [
                    'label'     => __( 'Active Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .swiper-pagination-current' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'navigation' => 'arrows-fraction',
                    ],
                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'      => 'fraction_typography',
                    'label'     => esc_html__( 'Typography', 'bdthemes-element-pack' ),
                    //'scheme'    => Schemes\Typography::TYPOGRAPHY_4,
                    'selector'  => '{{WRAPPER}} .bdt-carousel .swiper-pagination-fraction',
                    'condition' => [
                        'navigation' => 'arrows-fraction',
                    ],
                ]
            );
            
            $this->add_control(
                'hr_3',
                [
                    'type'      => Controls_Manager::DIVIDER,
                    'condition' => [
                        'navigation' => 'progressbar',
                    ],
                ]
            );
            
            $this->add_control(
                'progresbar_heading',
                [
                    'label'     => __( 'Progresbar', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::HEADING,
                    'condition' => [
                        'navigation' => 'progressbar',
                    ],
                ]
            );
            
            $this->add_control(
                'hr_13',
                [
                    'type'      => Controls_Manager::DIVIDER,
                    'condition' => [
                        'navigation' => 'progressbar',
                    ],
                ]
            );
            
            $this->add_control(
                'progresbar_color',
                [
                    'label'     => __( 'Bar Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .swiper-pagination-progressbar' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'navigation' => 'progressbar',
                    ],
                ]
            );
            
            $this->add_control(
                'progres_color',
                [
                    'label'     => __( 'Progress Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'separator' => 'after',
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .swiper-pagination-progressbar .swiper-pagination-progressbar-fill' => 'background: {{VALUE}}',
                    ],
                    'condition' => [
                        'navigation' => 'progressbar',
                    ],
                ]
            );
            
            $this->add_control(
                'hr_4',
                [
                    'type'      => Controls_Manager::DIVIDER,
                    'condition' => [
                        'show_scrollbar' => 'yes'
                    ],
                ]
            );
            
            $this->add_control(
                'scrollbar_heading',
                [
                    'label'     => __( 'Scrollbar', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::HEADING,
                    'condition' => [
                        'show_scrollbar' => 'yes'
                    ],
                ]
            );
            
            $this->add_control(
                'hr_14',
                [
                    'type'      => Controls_Manager::DIVIDER,
                    'condition' => [
                        'show_scrollbar' => 'yes'
                    ],
                ]
            );
            
            $this->add_control(
                'scrollbar_color',
                [
                    'label'     => __( 'Bar Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .swiper-scrollbar' => 'background: {{VALUE}}',
                    ],
                    'condition' => [
                        'show_scrollbar' => 'yes'
                    ],
                ]
            );
            
            $this->add_control(
                'scrollbar_drag_color',
                [
                    'label'     => __( 'Drag Color', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .swiper-scrollbar .swiper-scrollbar-drag' => 'background: {{VALUE}}',
                    ],
                    'condition' => [
                        'show_scrollbar' => 'yes'
                    ],
                ]
            );
            
            $this->add_control(
                'scrollbar_height',
                [
                    'label'     => __( 'Height', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'range'     => [
                        'px' => [
                            'min' => 1,
                            'max' => 10,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .swiper-container-horizontal > .swiper-scrollbar' => 'height: {{SIZE}}px;',
                    ],
                    'condition' => [
                        'show_scrollbar' => 'yes'
                    ],
                ]
            );
            
            $this->add_control(
                'hr_05',
                [
                    'type' => Controls_Manager::DIVIDER,
                ]
            );
            
            $this->add_control(
                'navi_offset_heading',
                [
                    'label' => __( 'Offset', 'bdthemes-element-pack' ),
                    'type'  => Controls_Manager::HEADING,
                ]
            );
            
            $this->add_control(
                'hr_6',
                [
                    'type' => Controls_Manager::DIVIDER,
                ]
            );
            
            $this->add_responsive_control(
                'arrows_ncx_position',
                [
                    'label'          => __( 'Arrows Horizontal Offset', 'bdthemes-element-pack' ),
                    'type'           => Controls_Manager::SLIDER,
                    'default'        => [
                        'size' => 0,
                    ],
                    'tablet_default' => [
                        'size' => 0,
                    ],
                    'mobile_default' => [
                        'size' => 0,
                    ],
                    'range'          => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'conditions'     => [
                        'terms' => [
                            [
                                'name'  => 'navigation',
                                'value' => 'arrows',
                            ],
                            [
                                'name'     => 'arrows_position',
                                'operator' => '!=',
                                'value'    => 'center',
                            ],
                        ],
                    ],
                    'selectors'      => [
                        '{{WRAPPER}}' => '--ep-carousel-arrows-ncx: {{SIZE}}px;'
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'arrows_ncy_position',
                [
                    'label'          => __( 'Arrows Vertical Offset', 'bdthemes-element-pack' ),
                    'type'           => Controls_Manager::SLIDER,
                    'default'        => [
                        'size' => 40,
                    ],
                    'tablet_default' => [
                        'size' => 40,
                    ],
                    'mobile_default' => [
                        'size' => 40,
                    ],
                    'range'          => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'selectors'      => [
                        '{{WRAPPER}}' => '--ep-carousel-arrows-ncy: {{SIZE}}px;'
                    ],
                    'conditions'     => [
                        'terms' => [
                            [
                                'name'  => 'navigation',
                                'value' => 'arrows',
                            ],
                            [
                                'name'     => 'arrows_position',
                                'operator' => '!=',
                                'value'    => 'center',
                            ],
                        ],
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'arrows_acx_position',
                [
                    'label'      => __( 'Arrows Horizontal Offset', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::SLIDER,
                    'default'    => [
                        'size' => -60,
                    ],
                    'range'      => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-prev' => 'left: {{SIZE}}px;',
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-next' => 'right: {{SIZE}}px;',
                    ],
                    'conditions' => [
                        'terms' => [
                            [
                                'name'  => 'navigation',
                                'value' => 'arrows',
                            ],
                            [
                                'name'  => 'arrows_position',
                                'value' => 'center',
                            ],
                        ],
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'dots_nnx_position',
                [
                    'label'          => __( 'Dots Horizontal Offset', 'bdthemes-element-pack' ),
                    'type'           => Controls_Manager::SLIDER,
                    'default'        => [
                        'size' => 0,
                    ],
                    'tablet_default' => [
                        'size' => 0,
                    ],
                    'mobile_default' => [
                        'size' => 0,
                    ],
                    'range'          => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'conditions'     => [
                        'terms' => [
                            [
                                'name'  => 'navigation',
                                'value' => 'dots',
                            ],
                            [
                                'name'     => 'dots_position',
                                'operator' => '!=',
                                'value'    => '',
                            ],
                        ],
                    ],
                    'selectors'      => [
                        '{{WRAPPER}}' => '--ep-carousel-dots-nnx: {{SIZE}}px;'
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'dots_nny_position',
                [
                    'label'          => __( 'Dots Vertical Offset', 'bdthemes-element-pack' ),
                    'type'           => Controls_Manager::SLIDER,
                    'default'        => [
                        'size' => 30,
                    ],
                    'tablet_default' => [
                        'size' => 30,
                    ],
                    'mobile_default' => [
                        'size' => 30,
                    ],
                    'range'          => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'conditions'     => [
                        'terms' => [
                            [
                                'name'  => 'navigation',
                                'value' => 'dots',
                            ],
                            [
                                'name'     => 'dots_position',
                                'operator' => '!=',
                                'value'    => '',
                            ],
                        ],
                    ],
                    'selectors'      => [
                        '{{WRAPPER}}' => '--ep-carousel-dots-nny: {{SIZE}}px;'
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'both_ncx_position',
                [
                    'label'          => __( 'Arrows & Dots Horizontal Offset', 'bdthemes-element-pack' ),
                    'type'           => Controls_Manager::SLIDER,
                    'default'        => [
                        'size' => 0,
                    ],
                    'tablet_default' => [
                        'size' => 0,
                    ],
                    'mobile_default' => [
                        'size' => 0,
                    ],
                    'range'          => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'conditions'     => [
                        'terms' => [
                            [
                                'name'  => 'navigation',
                                'value' => 'both',
                            ],
                            [
                                'name'     => 'both_position',
                                'operator' => '!=',
                                'value'    => 'center',
                            ],
                        ],
                    ],
                    'selectors'      => [
                        '{{WRAPPER}}' => '--ep-carousel-both-ncx: {{SIZE}}px;'
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'both_ncy_position',
                [
                    'label'          => __( 'Arrows & Dots Vertical Offset', 'bdthemes-element-pack' ),
                    'type'           => Controls_Manager::SLIDER,
                    'default'        => [
                        'size' => 40,
                    ],
                    'tablet_default' => [
                        'size' => 40,
                    ],
                    'mobile_default' => [
                        'size' => 40,
                    ],
                    'range'          => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'conditions'     => [
                        'terms' => [
                            [
                                'name'  => 'navigation',
                                'value' => 'both',
                            ],
                            [
                                'name'     => 'both_position',
                                'operator' => '!=',
                                'value'    => 'center',
                            ],
                        ],
                    ],
                    'selectors'      => [
                        '{{WRAPPER}}' => '--ep-carousel-both-ncy: {{SIZE}}px;'
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'both_cx_position',
                [
                    'label'      => __( 'Arrows Offset', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::SLIDER,
                    'default'    => [
                        'size' => -60,
                    ],
                    'range'      => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-prev' => 'left: {{SIZE}}px;',
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-next' => 'right: {{SIZE}}px;',
                    ],
                    'conditions' => [
                        'terms' => [
                            [
                                'name'  => 'navigation',
                                'value' => 'both',
                            ],
                            [
                                'name'  => 'both_position',
                                'value' => 'center',
                            ],
                        ],
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'both_cy_position',
                [
                    'label'      => __( 'Dots Offset', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::SLIDER,
                    'default'    => [
                        'size' => 30,
                    ],
                    'range'      => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .bdt-dots-container' => 'transform: translateY({{SIZE}}px);',
                    ],
                    'conditions' => [
                        'terms' => [
                            [
                                'name'  => 'navigation',
                                'value' => 'both',
                            ],
                            [
                                'name'  => 'both_position',
                                'value' => 'center',
                            ],
                        ],
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'arrows_fraction_ncx_position',
                [
                    'label'          => __( 'Arrows & Fraction Horizontal Offset', 'bdthemes-element-pack' ),
                    'type'           => Controls_Manager::SLIDER,
                    'default'        => [
                        'size' => 0,
                    ],
                    'tablet_default' => [
                        'size' => 0,
                    ],
                    'mobile_default' => [
                        'size' => 0,
                    ],
                    'range'          => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'conditions'     => [
                        'terms' => [
                            [
                                'name'  => 'navigation',
                                'value' => 'arrows-fraction',
                            ],
                            [
                                'name'     => 'arrows_fraction_position',
                                'operator' => '!=',
                                'value'    => 'center',
                            ],
                        ],
                    ],
                    'selectors'      => [
                        '{{WRAPPER}}' => '--ep-carousel-arrows-fraction-ncx: {{SIZE}}px;'
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'arrows_fraction_ncy_position',
                [
                    'label'          => __( 'Arrows & Fraction Vertical Offset', 'bdthemes-element-pack' ),
                    'type'           => Controls_Manager::SLIDER,
                    'default'        => [
                        'size' => 40,
                    ],
                    'tablet_default' => [
                        'size' => 40,
                    ],
                    'mobile_default' => [
                        'size' => 40,
                    ],
                    'range'          => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'conditions'     => [
                        'terms' => [
                            [
                                'name'  => 'navigation',
                                'value' => 'arrows-fraction',
                            ],
                            [
                                'name'     => 'arrows_fraction_position',
                                'operator' => '!=',
                                'value'    => 'center',
                            ],
                        ],
                    ],
                    'selectors'      => [
                        '{{WRAPPER}}' => '--ep-carousel-arrows-fraction-ncy: {{SIZE}}px;'
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'arrows_fraction_cx_position',
                [
                    'label'      => __( 'Arrows Offset', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::SLIDER,
                    'default'    => [
                        'size' => -60,
                    ],
                    'range'      => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-prev' => 'left: {{SIZE}}px;',
                        '{{WRAPPER}} .bdt-carousel .bdt-navigation-next' => 'right: {{SIZE}}px;',
                    ],
                    'conditions' => [
                        'terms' => [
                            [
                                'name'  => 'navigation',
                                'value' => 'arrows-fraction',
                            ],
                            [
                                'name'  => 'arrows_fraction_position',
                                'value' => 'center',
                            ],
                        ],
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'arrows_fraction_cy_position',
                [
                    'label'      => __( 'Fraction Offset', 'bdthemes-element-pack' ),
                    'type'       => Controls_Manager::SLIDER,
                    'default'    => [
                        'size' => 30,
                    ],
                    'range'      => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .bdt-carousel .swiper-pagination-fraction' => 'transform: translateY({{SIZE}}px);',
                    ],
                    'conditions' => [
                        'terms' => [
                            [
                                'name'  => 'navigation',
                                'value' => 'arrows-fraction',
                            ],
                            [
                                'name'  => 'arrows_fraction_position',
                                'value' => 'center',
                            ],
                        ],
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'progress_y_position',
                [
                    'label'     => __( 'Progress Offset', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'default'   => [
                        'size' => 15,
                    ],
                    'range'     => [
                        'px' => [
                            'min' => -200,
                            'max' => 200,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .swiper-pagination-progressbar' => 'transform: translateY({{SIZE}}px);',
                    ],
                    'condition' => [
                        'navigation' => 'progressbar',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'scrollbar_vertical_offset',
                [
                    'label'     => __( 'Scrollbar Offset', 'bdthemes-element-pack' ),
                    'type'      => Controls_Manager::SLIDER,
                    'selectors' => [
                        '{{WRAPPER}} .bdt-carousel .swiper-container-horizontal > .swiper-scrollbar' => 'bottom: {{SIZE}}px;',
                    ],
                    'condition' => [
                        'show_scrollbar' => 'yes'
                    ],
                ]
            );
            
            $this->end_controls_section();
        }
        
        public function get_taxonomies() {
            $taxonomies = get_taxonomies( ['show_in_nav_menus' => true], 'objects' );
            
            $options = ['' => ''];
            
            foreach ( $taxonomies as $taxonomy ) {
                $options[$taxonomy->name] = $taxonomy->label;
            }
            
            return $options;
        }
        
        public function get_posts_tags() {
            $taxonomy = $this->get_settings( 'taxonomy' );
            
            foreach ( $this->_query->posts as $post ) {
                if ( !$taxonomy ) {
                    $post->tags = [];
                    
                    continue;
                }
                
                $tags = wp_get_post_terms( $post->ID, $taxonomy );
                
                $tags_slugs = [];
                
                foreach ( $tags as $tag ) {
                    $tags_slugs[$tag->term_id] = $tag;
                }
                
                $post->tags = $tags_slugs;
            }
        }
        
        public function query_posts() {
            $query_args = Module::get_query_args( 'posts', $this->get_settings() );
            
            $query_args['posts_per_page'] = $this->get_settings( 'posts_per_page' );
            
            $this->_query = new \WP_Query( $query_args );
        }
        
        public function render() {
            $this->query_posts();
            
            $wp_query = $this->get_query();
            
            if ( !$wp_query->found_posts ) {
                return;
            }
            
            $this->get_posts_tags();
            
            $this->render_header();
            
            while ( $wp_query->have_posts() ) {
                $wp_query->the_post();
                
                $this->render_post();
            }
            
            $this->render_footer();
            
            wp_reset_postdata();
        }
        
        public function render_thumbnail() {
            $settings = $this->get_settings_for_display();
            
            if ( 'yes' !== $settings['thumbnail_show'] ) {
                return;
            }
            
            $settings['thumbnail_size'] = [
                'id' => get_post_thumbnail_id(),
            ];
            
            $thumbnail_html = Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail_size' );
            $placeholder_image_src = Utils::get_placeholder_image_src();
            
            if ( !$thumbnail_html ) {
                $thumbnail_html = '<img src="' . esc_url( $placeholder_image_src ) . '" alt="' . get_the_title() . '">';
            }
            
            ?>
            <div class="bdt-carousel-thumbnail">
                
                <?php
                    if ( 'yes' == $settings['show_link_option'] ) { ?>
                <a href="<?php
                    echo get_permalink() ?>" title="<?php
                    echo get_the_title(); ?>">
                    <?php
                        } ?>
                    
                    <?php
                        echo wp_kses_post( $thumbnail_html ) ?>
                    
                    <?php
                        if ( 'yes' == $settings['show_link_option'] ) { ?>
                </a>
            <?php
                } ?>

            </div>
            <?php
        }
        
        public function render_meta_data() {
            $settings = $this->get_settings( 'meta_data' );
            if ( empty( $settings ) ) {
                return;
            }
            ?>
            <div class="bdt-carousel-meta bdt-subnav bdt-flex-middle bdt-margin-small-top" data-bdt-margin>
                <?php
                    if ( in_array( 'author', $settings ) ) {
                        $this->render_author();
                    }
                    
                    if ( in_array( 'category', $settings ) ) {
                        $this->render_category();
                    }
                    
                    if ( in_array( 'date', $settings ) ) {
                        $this->render_date();
                    }
                    
                    if ( in_array( 'time', $settings ) ) {
                        $this->render_time();
                    }
                    
                    if ( in_array( 'comments', $settings ) ) {
                        $this->render_comments();
                    }
                ?>
            </div>
            <?php
        }
        
        public function render_author() {
            ?>
            <span class="pc-author">
			<span><?php
                    the_author(); ?></span>
		</span>
            <?php
        }
        
        public function render_category() {
            ?>
            <span class="pc-category">
			<span><?php
                    echo get_the_category_list( ', ' ); ?></span>
		</span>
            <?php
        }
        
        public function render_date() {
            ?>
            <span class="pc-date">
			<span><?php
                    echo apply_filters( 'the_date', get_the_date( get_option( 'date_format' ) ), '', '' ); ?></span>
		</span>
            <?php
        }
        
        public function render_time() {
            ?>
            <span class="pc-time">
			<span><?php
                    the_time(); ?></span>
		</span>
            <?php
        }
        
        public function render_comments() {
            ?>
            <span class="pc-avatar">
			<span><?php
                    comments_number(); ?></span>
		</span>
            <?php
        }
        
        public function render_title() {
            if ( !$this->get_settings( 'show_title' ) ) {
                return;
            }
            
            $tag = $this->get_settings( 'title_tag' );
            $classes = ['bdt-carousel-title bdt-margin-small-bottom', 'bdt-margin-remove-top']
            ?>

            <<?php
            echo Utils::get_valid_html_tag( $tag ) ?> class="<?php
            echo implode( " ", $classes ); ?>">
            <a href="<?php
                echo get_permalink() ?>">
                <?php
                    the_title() ?>
            </a>
            </<?php
            echo Utils::get_valid_html_tag( $tag ) ?>>
            <?php
        }
        
        public function render_excerpt() {
            if ( !$this->get_settings( 'show_excerpt' ) ) {
                return;
            }
            
            $strip_shortcode = $this->get_settings_for_display( 'strip_shortcode' );
            
            ?>
            <div class="bdt-carousel-excerpt">
                <?php
                    if ( has_excerpt() ) {
                        the_excerpt();
                    } else {
                        echo element_pack_custom_excerpt( $this->get_settings_for_display( 'excerpt_length' ), $strip_shortcode );
                    }
                ?>
            </div>
            <?php
        }
        
        public function render_readmore() {
            if ( !$this->get_settings( 'show_read_more' ) ) {
                return;
            }
            
            $settings = $this->get_settings_for_display();
            $animation = ( $settings['button_hover_animation'] ) ? ' elementor-animation-' . $settings['button_hover_animation'] : '';
            
            if ( 'left' == $settings['icon_align'] or 'right' == $settings['icon_align'] ) {
                $this->add_render_attribute( 'carousel-button', 'class', 'bdt-flex bdt-flex-middle', 'true' );
            }
            
            if ( !isset( $settings['icon'] ) && !Icons_Manager::is_migration_allowed() ) {
                // add old default
                $settings['icon'] = 'fas fa-arrow-right';
            }
            
            $migrated = isset( $settings['__fa4_migrated']['carousel_icon'] );
            $is_new = empty( $settings['icon'] ) && Icons_Manager::is_migration_allowed();
            
            ?>
            <a class="bdt-carousel-button elementor-button elementor-size-<?php
                echo esc_attr( $settings['button_size'] . $animation ); ?>" href="<?php
                echo get_permalink(); ?>">
			<span <?php
                echo $this->get_render_attribute_string( 'carousel-button' ); ?>>
				<?php
                    echo esc_html( $settings['read_more_text'] ); ?>
                
                <?php
                    if ( $settings['carousel_icon']['value'] ) : ?>
                        <span class="bdt-carousel-button-icon bdt-flex-align-<?php
                            echo esc_attr( $settings['icon_align'] ); ?>">

						<?php
                            if ( $is_new || $migrated ) :
                                Icons_Manager::render_icon( $settings['carousel_icon'], ['aria-hidden' => 'true', 'class' => 'fa-fw'] );
                            else : ?>
                                <i class="<?php
                                    echo esc_attr( $settings['icon'] ); ?>" aria-hidden="true"></i>
                            <?php
                            endif; ?>

					</span>
                    <?php
                    endif; ?>
			</span>

            </a>
            <?php
        }
        
        public function render_loop_header() {
            global $post;
            
            $tags_classes = array_map( function ( $tag ) {
                return 'bdt-carousel-filter-' . $tag->term_id;
            }, $post->tags );
            
            $classes = [
                'bdt-carousel-item',
                'swiper-slide',
                implode( ' ', $tags_classes ),
            ];
            
            ?>
            <div <?php
            post_class( $classes ); ?>>
            <?php
        }
        
        public function render_post_footer() {
            ?>
            </div>
            <?php
        }
        
        public function render_overlay_header() {
            $classes = ['bdt-carousel-desc'];
            if ( $this->get_settings( 'item_padding' ) == '' ) :
                $classes[] = 'bdt-margin-top';
            endif; ?>
            <div class="<?php
                echo implode( " ", $classes ); ?>">
            <?php
        }
        
        public function render_overlay_footer() {
            ?>
            </div>
            <?php
        }
        
        public function render_header( $skin = "default" ) {
            $id = 'bdt-carousel-' . $this->get_id();
            $settings = $this->get_settings_for_display();
            $elementor_vp_lg = get_option( 'elementor_viewport_lg' );
            $elementor_vp_md = get_option( 'elementor_viewport_md' );
            $viewport_lg = !empty( $elementor_vp_lg ) ? $elementor_vp_lg - 1 : 1023;
            $viewport_md = !empty( $elementor_vp_md ) ? $elementor_vp_md - 1 : 767;
            
            $this->add_render_attribute( 'carousel', 'id', $id );
            $this->add_render_attribute( 'carousel', 'class', ['bdt-carousel', 'bdt-carousel-skin-' . $skin] );
            
            if ( 'yes' == $settings['match_height'] ) {
                $this->add_render_attribute( 'carousel', 'bdt-height-match', 'target: > div > div > .bdt-carousel-item' );
            }
            
            if ( 'arrows' == $settings['navigation'] ) {
                $this->add_render_attribute( 'carousel', 'class', 'bdt-arrows-align-' . $settings['arrows_position'] );
            } elseif ( 'dots' == $settings['navigation'] ) {
                $this->add_render_attribute( 'carousel', 'class', 'bdt-dots-align-' . $settings['dots_position'] );
            } elseif ( 'both' == $settings['navigation'] ) {
                $this->add_render_attribute( 'carousel', 'class', 'bdt-arrows-dots-align-' . $settings['both_position'] );
            } elseif ( 'arrows-fraction' == $settings['navigation'] ) {
                $this->add_render_attribute( 'carousel', 'class', 'bdt-arrows-dots-align-' . $settings['arrows_fraction_position'] );
            }
            
            if ( 'arrows-fraction' == $settings['navigation'] ) {
                $pagination_type = 'fraction';
            } elseif ( 'both' == $settings['navigation'] or 'dots' == $settings['navigation'] ) {
                $pagination_type = 'bullets';
            } elseif ( 'progressbar' == $settings['navigation'] ) {
                $pagination_type = 'progressbar';
            } else {
                $pagination_type = '';
            }
            
            $this->add_render_attribute(
                [
                    'carousel' => [
                        'data-settings' => [
                            wp_json_encode( array_filter( [
                                "autoplay"        => ( "yes" == $settings["autoplay"] ) ? ["delay" => $settings["autoplay_speed"]] : false,
                                "loop"            => ( $settings["loop"] == "yes" ) ? true : false,
                                "speed"           => $settings["speed"]["size"],
                                "pauseOnHover"    => ( "yes" == $settings["pauseonhover"] ) ? true : false,
                                "slidesPerView"   => (int)$settings["columns_mobile"],
                                "slidesPerGroup"  => (int)$settings["slides_to_scroll_mobile"],
                                "spaceBetween"    => $settings["item_gap"]["size"],
                                "centeredSlides"  => ( $settings["centered_slides"] === "yes" ) ? true : false,
                                "grabCursor"      => ( $settings["grab_cursor"] === "yes" ) ? true : false,
                                "effect"          => $settings["skin"],
                                "observer"        => ( $settings["observer"] ) ? true : false,
                                "observeParents"  => ( $settings["observer"] ) ? true : false,
                                "breakpoints"     => [
                                    (int)$viewport_md => [
                                        "slidesPerView"  => (int)$settings["columns_tablet"],
                                        "spaceBetween"   => $settings["item_gap"]["size"],
                                        "slidesPerGroup" => (int)$settings["slides_to_scroll_tablet"]
                                    ],
                                    (int)$viewport_lg => [
                                        "slidesPerView"  => (int)$settings["columns"],
                                        "spaceBetween"   => $settings["item_gap"]["size"],
                                        "slidesPerGroup" => (int)$settings["slides_to_scroll"]
                                    ]
                                ],
                                "navigation"      => [
                                    "nextEl" => "#" . $id . " .bdt-navigation-next",
                                    "prevEl" => "#" . $id . " .bdt-navigation-prev",
                                ],
                                "pagination"      => [
                                    "el"             => "#" . $id . " .swiper-pagination",
                                    "type"           => $pagination_type,
                                    "clickable"      => "true",
                                    'dynamicBullets' => ( "yes" == $settings["dynamic_bullets"] ) ? true : false,
                                ],
                                "scrollbar"       => [
                                    "el"   => "#" . $id . " .swiper-scrollbar",
                                    "hide" => "true",
                                ],
                                'coverflowEffect' => [
                                    'rotate'       => ( "yes" == $settings["coverflow_toggle"] ) ? $settings["coverflow_rotate"]["size"] : 50,
                                    'stretch'      => ( "yes" == $settings["coverflow_toggle"] ) ? $settings["coverflow_stretch"]["size"] : 0,
                                    'depth'        => ( "yes" == $settings["coverflow_toggle"] ) ? $settings["coverflow_depth"]["size"] : 100,
                                    'modifier'     => ( "yes" == $settings["coverflow_toggle"] ) ? $settings["coverflow_modifier"]["size"] : 1,
                                    'slideShadows' => true,
                                ],
                            
                            ] ) )
                        ]
                    ]
                ]
            );
            
            ?>
            <div <?php
            echo $this->get_render_attribute_string( 'carousel' ); ?>>
            <div class="swiper-container">
            <div class="swiper-wrapper">
            <?php
        }
        
        public function render_navigation() {
            $settings = $this->get_settings_for_display();
            $hide_arrow_on_mobile = $settings['hide_arrow_on_mobile'] ? ' bdt-visible@m' : '';
            
            if ( 'arrows' == $settings['navigation'] ) : ?>
                <div class="bdt-position-z-index bdt-position-<?php
                    echo esc_attr( $settings['arrows_position'] . $hide_arrow_on_mobile ); ?>">
                    <div class="bdt-arrows-container bdt-slidenav-container">
                        <a href="" class="bdt-navigation-prev bdt-slidenav-previous bdt-icon bdt-slidenav">
                            <i class="ep-arrow-left-<?php
                                echo esc_attr( $settings['nav_arrows_icon'] ); ?>" aria-hidden="true"></i>
                        </a>
                        <a href="" class="bdt-navigation-next bdt-slidenav-next bdt-icon bdt-slidenav">
                            <i class="ep-arrow-right-<?php
                                echo esc_attr( $settings['nav_arrows_icon'] ); ?>" aria-hidden="true"></i>
                        </a>
                    </div>
                </div>
            <?php
            endif;
        }
        
        public function render_pagination() {
            $settings = $this->get_settings_for_display();
            
            if ( 'dots' == $settings['navigation'] or 'arrows-fraction' == $settings['navigation'] ) : ?>
                <div class="bdt-position-z-index bdt-position-<?php
                    echo esc_attr( $settings['dots_position'] ); ?>">
                    <div class="bdt-dots-container">
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            
            <?php
            elseif ( 'progressbar' == $settings['navigation'] ) : ?>
                <div class="swiper-pagination bdt-position-z-index bdt-position-<?php
                    echo esc_attr( $settings['progress_position'] ); ?>"></div>
            <?php
            endif;
        }
        
        public function render_both_navigation() {
            $settings = $this->get_settings_for_display();
            $hide_arrow_on_mobile = $settings['hide_arrow_on_mobile'] ? 'bdt-visible@m' : '';
            
            ?>
            <div class="bdt-position-z-index bdt-position-<?php
                echo esc_attr( $settings['both_position'] ); ?>">
                <div class="bdt-arrows-dots-container bdt-slidenav-container ">

                    <div class="bdt-flex bdt-flex-middle">
                        <div class="<?php
                            echo esc_attr( $hide_arrow_on_mobile ); ?>">
                            <a href="" class="bdt-navigation-prev bdt-slidenav-previous bdt-icon bdt-slidenav">
                                <i class="ep-arrow-left-<?php
                                    echo esc_attr( $settings['nav_arrows_icon'] ); ?>" aria-hidden="true"></i>
                            </a>
                        </div>
                        
                        <?php
                            if ( 'center' !== $settings['both_position'] ) : ?>
                                <div class="swiper-pagination"></div>
                            <?php
                            endif; ?>

                        <div class="<?php
                            echo esc_attr( $hide_arrow_on_mobile ); ?>">
                            <a href="" class="bdt-navigation-next bdt-slidenav-next bdt-icon bdt-slidenav">
                                <i class="ep-arrow-right-<?php
                                    echo esc_attr( $settings['nav_arrows_icon'] ); ?>" aria-hidden="true"></i>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
            <?php
        }
        
        public function render_arrows_fraction() {
            $settings = $this->get_settings_for_display();
            $hide_arrow_on_mobile = $settings['hide_arrow_on_mobile'] ? 'bdt-visible@m' : '';
            
            ?>
            <div class="bdt-position-z-index bdt-position-<?php
                echo esc_attr( $settings['arrows_fraction_position'] ); ?>">
                <div class="bdt-arrows-fraction-container bdt-slidenav-container ">

                    <div class="bdt-flex bdt-flex-middle">
                        <div class="<?php
                            echo esc_attr( $hide_arrow_on_mobile ); ?>">
                            <a href="" class="bdt-navigation-prev bdt-slidenav-previous bdt-icon bdt-slidenav">
                                <i class="ep-arrow-left-<?php
                                    echo esc_attr( $settings['nav_arrows_icon'] ); ?>" aria-hidden="true"></i>
                            </a>
                        </div>
                        
                        <?php
                            if ( 'center' !== $settings['arrows_fraction_position'] ) : ?>
                                <div class="swiper-pagination"></div>
                            <?php
                            endif; ?>

                        <div class="<?php
                            echo esc_attr( $hide_arrow_on_mobile ); ?>">
                            <a href="" class="bdt-navigation-next bdt-slidenav-next bdt-icon bdt-slidenav">
                                <i class="ep-arrow-right-<?php
                                    echo esc_attr( $settings['nav_arrows_icon'] ); ?>" aria-hidden="true"></i>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
            <?php
        }
        
        public function render_footer() {
            $settings = $this->get_settings_for_display();
            
            ?>
            </div>
            <?php
            if ( 'yes' === $settings['show_scrollbar'] ) : ?>
                <div class="swiper-scrollbar"></div>
            <?php
            endif; ?>
            </div>
            
            <?php
            if ( 'both' == $settings['navigation'] ) : ?>
                <?php
                $this->render_both_navigation(); ?>
                <?php
                if ( 'center' === $settings['both_position'] ) : ?>
                    <div class="bdt-position-z-index bdt-position-bottom">
                        <div class="bdt-dots-container">
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                <?php
                endif; ?>
            <?php
            elseif ( 'arrows-fraction' == $settings['navigation'] ) : ?>
                <?php
                $this->render_arrows_fraction(); ?>
                <?php
                if ( 'center' === $settings['arrows_fraction_position'] ) : ?>
                    <div class="bdt-dots-container">
                        <div class="swiper-pagination"></div>
                    </div>
                <?php
                endif; ?>
            <?php
            else : ?>
                <?php
                $this->render_pagination(); ?>
                <?php
                $this->render_navigation(); ?>
            <?php
            endif; ?>

            </div>
            
            <?php
        }
        
        public function render_post() {
            $this->render_loop_header();
            $this->render_thumbnail();
            $this->render_overlay_header();
            $this->render_title();
            $this->render_meta_data();
            $this->render_excerpt();
            $this->render_readmore();
            $this->render_overlay_footer();
            $this->render_post_footer();
        }
    }
