<?php

function dzsap_admin_echo_registeredUsersCapabilityMainOption($dzsap) {

$lab = 'allow_download_only_for_registered_users_capability';
$dependency = array(
  array(
    'element' => 'allow_download_only_for_registered_users',
    'value' => array('on'),
  ),
);
?>
<div class="setting" data-dependency='<?php echo json_encode($dependency); ?>'>
  <h4 class="label"><?php echo __('Required user role for download', DZSAP_ID); ?></h4>
  <?php


  $seekval = 'read';

  if($dzsap->mainoptions[$lab]){
    $seekval = $dzsap->mainoptions[$lab];
  }



  $opts = array(
    array(
      'label' => __("Subscriber"),
      'value' => 'read'
    ),
    array(
      'label' => __("Contributor"),
      'value' => 'edit_posts'
    ),
    array(
      'label' => __("Author"),
      'value' => 'edit_published_posts',
    ),

  );
  $opts_default = $opts;

  $optsAllCaps = array();
  $all_caps = get_role( 'administrator' )->capabilities;
  foreach ($all_caps as $keyCap => $valCap){
    if($keyCap!='read' && $keyCap!='edit_posts' && $keyCap!='edit_published_posts'){
      array_push($optsAllCaps, array(
        'label' => $keyCap,
        'value' => $keyCap,
      ));
    }
  }


  ?>
  <select name="<?= $lab ?>" class=" styleme "><optgroup label="<?= esc_html__("Default roles", DZSAP_ID) ?>"><?php
      $fout = '';
      foreach ($opts_default as $key => $valOpt){

        $fout .= '<option value="' . $valOpt['value'] . '"';
        if ($seekval != '' && $seekval == $valOpt['value']) {
          $fout .= ' selected';
        }

        $fout .= '>' . $valOpt['label'] . '</option>';
      }
      echo $fout;
      ?></optgroup><optgroup label="<?= esc_html__("Custom permissions", DZSAP_ID) ?>"><?php
      $fout = '';
      foreach ($optsAllCaps as $key => $valOpt){

        $fout .= '<option value="' . $valOpt['value'] . '"';
        if ($seekval != '' && $seekval == $valOpt['value']) {
          $fout .= ' selected';
        }

        $fout .= '>' . $valOpt['label'] . '</option>';
      }
      echo $fout;
      ?></optgroup></select>


  <div class="sidenote"><?php echo __("select a class to restrict downloads to", DZSAP_ID) . ''; ?></div>
</div><?php
}