<?php


class DzsapAdmin {

  private $dzsap;

  function __construct($dzsap) {

    $this->dzsap = $dzsap;

    add_action('add_meta_boxes', array($this, 'handle_add_meta_boxes'));
    add_action('admin_init', array($this, 'handle_admin_init'), 5);
//    add_action('admin_head', array($this, 'handle_admin_head_start'), 2);
    add_action('admin_head', array($this, 'handle_admin_head'), 5);
    add_action('admin_menu', array($this, 'handle_admin_menu'));
    add_action('add_attachment', array($this, 'handle_add_attachment'));

//    add_action( 'admin_print_footer_scripts', array($this, 'handle_admin_print_footer_scripts', 50 ));

    add_filter('attachment_fields_to_edit', array($this, 'filter_attachment_fields_to_edit'), 10, 2);
    add_filter('attachment_fields_to_save', array($this, "filter_attachment_fields_to_save"), null, 2);



    if (isset($_GET['taxonomy']) && $_GET['taxonomy'] == DZSAP_TAXONOMY_NAME_SLIDERS) {
      include_once(DZSAP_BASE_PATH.'admin/sliders_admin.php');
      add_action('in_admin_footer', 'dzsap_sliders_admin');
    }


    add_action('save_post', array($this, 'admin_meta_save'));
    add_action('admin_footer', array($this, 'handle_admin_footer'));


  }
//  function handle_admin_print_footer_scripts(){
//
//  }
  function handle_add_attachment($postId){
    $thePost = get_post($postId);

//    error_log('$thePost - '.print_r($thePost,true));
//
//    $trackSource = DZSZoomSoundsHelper::media_getTrackSource($postId, $postId, $margs);
//    if($trackSource){
//
//      error_log('$trackSource - '.print_r($trackSource,true));
//    }



  }
  function handle_admin_footer() {


    if (isset($_GET['taxonomy']) && $_GET['taxonomy'] == DZSAP_TAXONOMY_NAME_SLIDERS) {
      echo '<script>';
      echo 'jQuery(document).ready(function($){';
      echo 'window.wp_pseudoHighlightMenuItem(\''.DZSAP_ADMIN_PAGENAME_PARENT.'\',\''.DZSAP_REGISTER_POST_TYPE_NAME.'\')';
      echo '});';
      echo '</script>';
    }

    if (isset($_GET['dzs_css'])) {

      if ($_GET['dzs_css'] == 'remove_wp_menu') {
        wp_enqueue_style('dzs.remove_wp_bar', DZSAP_BASE_URL . 'tinymce/remove_wp_bar.css');

      }
    }
  }


  function handle_admin_menu() {
    DZSZoomSoundsHelper::registerDzsapPages();

  }
  function admin_page_mainoptions() {
    $dzsap = $this->dzsap;
    //print_r($this->mainoptions);
    if (isset($_POST['dzsap_delete_plugin_data']) && $_POST['dzsap_delete_plugin_data'] == 'on') {


      // -- delete plugin data

      if ($dzsap->dbs && is_array($dzsap->dbs) && count($dzsap->dbs)) {

        foreach ($dzsap->dbs as $db) {

          $aux = DZSAP_DBNAME_MAINITEMS;
          $aux .= '-' . $db;

          delete_option($aux);
        }
      }

      delete_option(DZSAP_DBNAME_LEGACY_DBS);

      delete_option(DZSAP_DBNAME_MAINITEMS);
      delete_option(DZSAP_DBNAME_AUDIO_PLAYERS_CONFIGS);
      delete_option(DZSAP_DBNAME_OPTIONS);
    }


    if (isset($_GET['dzsap_shortcode_builder']) && $_GET['dzsap_shortcode_builder'] == 'on') {
      dzsap_shortcode_builder();
    } elseif (isset($_GET['dzsap_shortcode_player_builder']) && $_GET['dzsap_shortcode_player_builder'] == 'on') {


      dzsap_shortcode_player_builder();
    } elseif (isset($_GET['dzsap_preview_player']) && $_GET['dzsap_preview_player'] == 'on') {

      include_once DZSAP_BASE_PATH."class_parts/admin-preview-player.php";



      dzsap_preview_player();
    }  elseif (isset($_GET[DZSAP_ADMIN_PAGENAME_MAINOPTIONS_WAVE_GENERATOR]) && $_GET[DZSAP_ADMIN_PAGENAME_MAINOPTIONS_WAVE_GENERATOR] == 'on') {

      include_once DZSAP_BASE_PATH . 'inc/php/admin-pages/page_wave_regenerate-functions.php';


      dzsap_wave_regenerate_admin_page();
    } else {

      include_once DZSAP_BASE_PATH."class_parts/admin-page-mainoptions.php";
    }

    ?>


    <div class="clear"></div><br/>
    <?php
    DZSZoomSoundsHelper::embedZoomTabsAndAccordions();
    wp_enqueue_script('jquery-ui-slider');
  }


  function wp_dashboard_setup() {

    $dzsap = $this->dzsap;

    if ($dzsap->mainoptions['analytics_enable'] == 'on') {

      wp_add_dashboard_widget('dzsap_dashboard_analytics', // Widget slug.
        'ZoomSounds' . esc_html__('Analytics', DZSAP_ID), // Title.
        'dzsap_analytics_dashboard_content'

      );
    }

  }

  /**
   * deprecated ?
   */
  function dashboard_comments_display() {

//	echo "Hello World, I'm a great Dashboard Widget";

    $type = 'attachement';
    $args = array(
      'post_type' => 'attachment',
      'numberposts' => null,
      'posts_per_page' => '-1',
      'post_mime_type' => 'audio',
      'post_status' => null
    );
    $attachments = get_posts($args);

    $arr_attcomms = array();
    foreach ($attachments as $att) {
      $comments_count = wp_count_comments($att->ID);
      $aux = array('id' => $att->ID, 'commnr' => ($comments_count->approved));
      array_push($arr_attcomms, $aux);
    }
    //print_r($arr_attcomms);


    usort($arr_attcomms, array('DZSZoomSoundsHelper', 'sort_commnr'));

//        print_r($arr_attcomms);


    echo '<div id="dzsap_chart_div"></div>';
    //print_r($arr_attcomms);


    ?>
    <script type="text/javascript"><?php

      ?>
      google.load("visualization", "1.0", {"packages": ["corechart"]});


      google.setOnLoadCallback(dzsap_drawChart);


      function dzsap_drawChart() {

        var data = new google.visualization.DataTable();
        data.addColumn("string", "Topping");
        data.addColumn("number", "Slices");
        data.addRows([<?php
          $i = 0;
          foreach ($arr_attcomms as $att) {
            echo '';
//            ['Mushrooms', 3],
            $auxpo = get_post($att['id']);
//            print_r($aux);

            if ($i > 0) {
              echo ',';
            }
            echo '["' . $auxpo->post_title . '", ' . $att['commnr'] . ']';
            $i++;
            //echo 'Track <strong>'.$att['id'].'</strong>, '.$auxpo->post_title.' - '.$att['commnr'].' comments<br/>';
          };
          ?>]);
        var options = {
          "title": "' . esc_html__('Number of Comments', DZSAP_ID) . '",
          "width": "100%",
          "height": 300
        };
        var chart = new google.visualization.PieChart(document.getElementById("dzsap_chart_div"));
        chart.draw(data, options);
      }
    </script><?php


  }


  function do_backup() {
    // -- generate backup
    $dzsap = $this->dzsap;

    $timestamp = time();

//        echo 'time - '.$timestamp;

    $data = get_option(DZSAP_DBNAME_MAINITEMS);

    if (is_array($data)) {
      $data = serialize($data);
    }

//        echo ' data - '.$data;
//        file_put_contents('backups/backup_'.$timestamp,$data);
    $upload_dir = wp_upload_dir();


    error_log('do_backup()' . ' ' . time());

    if (file_exists($upload_dir['basedir'] . '/dzsap_backups')) {

//            echo 'dada';
    } else {

//            echo 'nunu';
      mkdir($upload_dir['basedir'] . '/dzsap_backups', 0755);
    }

    file_put_contents($upload_dir['basedir'] . '/dzsap_backups/backup_' . $timestamp . '.txt', $data);


//        $theurl_forwaveforms = $upload_dir['url'].'/';

//        echo $upload_dir['basedir'] . '/dzsap_backups/backup_' . $timestamp . '.txt';

//        print_r($upload_dir);

    update_option('dzsap_last_backup', $timestamp);


    if ($dzsap->mainoptions['playlists_mode'] == 'normal') {


      $terms = get_terms(DZSAP_TAXONOMY_NAME_SLIDERS, array(
        'hide_empty' => false,
      ));

      foreach ($terms as $term) {

        $data = $dzsap->classAdmin->playlist_export($term->term_id);

        if (is_array($data)) {
          $data = json_encode($data);
        }

        file_put_contents($upload_dir['basedir'] . '/dzsap_backups/backup_' . $term->slug . '_' . $timestamp . '.txt', $data);
      }
    } else {

      if (is_array($dzsap->dbs)) {
        foreach ($dzsap->dbs as $adb) {
          $data = get_option(DZSAP_DBNAME_MAINITEMS . '-' . $adb);

          if (is_array($data)) {
            $data = serialize($data);
          }

          file_put_contents($upload_dir['basedir'] . '/dzsap_backups/backup_' . $adb . '_' . $timestamp . '.txt', $data);


        }
      }
    }

    $logged_backups = array();
    try {

      $logged_backups = json_decode(get_option('dzsap_backuplog'), true);
    } catch (Exception $err) {

    }
    if (is_array($logged_backups) == false) {
      $logged_backups = array();
    }


    array_push($logged_backups, time());
    if (count($logged_backups) > 5) {
      array_shift($logged_backups);
    }


    update_option('dzsap_backuplog', json_encode($logged_backups));
  }


  function playlist_export($term_id, $pargs = array()) {


    $margs = array(
      'download_export' => false
    );

    $margs = array_merge($margs, $pargs);

    $term_meta = get_option("taxonomy_$term_id");

//		print_rr($term_meta);

    $tax = DZSAP_TAXONOMY_NAME_SLIDERS;

    $reference_term = get_term_by('id', $term_id, $tax);

//	        print_rr($reference_term);


    $reference_term_name = $reference_term->name;
    $reference_term_slug = $reference_term->slug;
    $selected_term_id = $reference_term->term_id;


    if ($selected_term_id) {

      $args = array(
        'post_type' => 'dzsap_items',
        'numberposts' => -1,
        'posts_per_page' => -1,
        //                'meta_key' => 'dzsap_meta_order_'.$selected_term,

        'orderby' => 'meta_value_num',
        'order' => 'ASC',
        'meta_query' => array(
          'relation' => 'OR',
          array(
            'key' => 'dzsap_meta_order_' . $selected_term_id,
            //                        'value' => '',
            'compare' => 'EXISTS',
          ),
          array(
            'key' => 'dzsap_meta_order_' . $selected_term_id,
            //                        'value' => '',
            'compare' => 'NOT EXISTS'
          )
        ),
        'tax_query' => array(
          array(
            'taxonomy' => $tax,
            'field' => 'id',
            'terms' => $selected_term_id // Where term_id of Term 1 is "1".
          )
        ),
      );

      $my_query = new WP_Query($args);

//            print_r($my_query);


//            print_r($my_query->posts);


      $arr_export = array(
        'original_term_id' => $selected_term_id,
        'original_term_slug' => $reference_term_slug,
        'original_term_name' => $reference_term_name,
        'original_site_url' => site_url(),
        'export_type' => 'meta_term',
        'term_meta' => $term_meta,
        'items' => array(),
      );

      foreach ($my_query->posts as $po) {

//                print_r($po);


        $po_sanitized = $this->sanitize_to_gallery_item($po);


        array_push($arr_export['items'], $po_sanitized);

//                print_rr($po);
//                print_rr($po_sanitized);
//			        print_rr($po);
      }


      if ($margs['download_export']) {
        header('Content-Type: text/plain');
        header('Content-Disposition: attachment; filename="' . "dzsap_export_" . $reference_term_slug . ".txt" . '"');
      }

      return $arr_export;
    } else {
      return array();
    }
  }

  public function sanitize_to_gallery_item($che) {

    $dzsap = $this->dzsap;
    $po_id = $che->ID;


    $che = (array)$che;


    $user_info = get_userdata($che['post_author']);

    if (isset($user_info) && $user_info && isset($user_info->first_name) && $user_info->first_name) {

      $che['artistname'] = $user_info->last_name . " " . $user_info->first_name;
    } else {

      if (isset($user_info->user_login)) {
        $che['artistname'] = $user_info->user_login;
      }
    }


    if (get_post_meta($po_id, 'dzsap_meta_replace_artistname', true)) {

      $che['artistname'] = get_post_meta($po_id, 'dzsap_meta_replace_artistname', true);
    }

    if (get_post_meta($po_id, 'dzsap_meta_replace_menu_artistname', true)) {

      $che['menu_artistname'] = get_post_meta($po_id, 'dzsap_meta_replace_menu_artistname', true);
    }

    if (get_post_meta($po_id, 'dzsap_meta_replace_menu_songname', true)) {

      $che['menu_songname'] = get_post_meta($po_id, 'dzsap_meta_replace_menu_songname', true);
    }


    $che['sourceogg'] = '';
    $che['source'] = get_post_meta($po_id, 'dzsap_meta_item_source', true);

    $che['songname'] = $che['post_title'];
    $che['playfrom'] = '0';
    $che['thumb'] = get_post_meta($po_id, 'dzsap_meta_item_thumb', true);
    $che['type'] = get_post_meta($po_id, 'dzsap_meta_type', true);
    $che['playerid'] = $po_id;


//        echo 'get_post_meta - '; print_rr(get_post_meta($po_id));


    // -- sanitize to gallery item
    foreach ($dzsap->options_item_meta as $oim) {

//        echo 'oim - '; print_rr($oim);

      if (isset($oim['name'])) {
        if ($oim['name'] === 'post_content') {
          continue;
        }


        $long_name = $oim['name'];
        $short_name = str_replace('dzsap_meta_item_', '', $oim['name']);
        $short_name = str_replace('dzsap_meta_', '', $short_name);


        $che[$oim['name']] = get_post_meta($po_id, $oim['name'], true);
        $che[$short_name] = get_post_meta($po_id, $long_name, true);
      } else {
        continue;
      }
    }

//    echo 'che - '; print_rr($che);


    $lab = 'dzsap_meta_source_attachment_id';
    if (get_post_meta($po_id, $lab, true)) {
      $che[$lab] = get_post_meta($po_id, $lab, true);
    }


    return $che;
  }


  function filter_attachment_fields_to_edit($form_fields, $post) {

    $dzsap = $this->dzsap;

    $vpconfigsstr = '';
    $the_id = $post->ID;
    $post_type = get_post_mime_type($the_id);

    ////print_r($post);


    if (strpos($post_type, "audio") === false) {
      return $form_fields;
    }

    foreach ($dzsap->mainitems_configs as $vpconfig) {
      //print_r($vpconfig);
      $vpconfigsstr .= '<option value="' . $vpconfig['settings']['id'] . '">' . $vpconfig['settings']['id'] . '</option>';
    }


    $html_sel = '<select class="styleme" id="attachments-' . $post->ID . '-dzsap-config" name="attachments[' . $post->ID . '][dzsap-config]"><option value="default">Default Settings</option>';
    $html_sel .= $vpconfigsstr;
    $html_sel .= '</select>';
    //$html_sel.='<div>'.$post_type.'</div>';

    $form_fields['dzsap-config'] = array(
      'label' => esc_html__('ZoomSounds Player Config', DZSAP_ID),
      'input' => 'html',
      'html' => $html_sel,
      'helps' => 'choose a configuration for the player / edit in ZoomSounds > Player Configs',
    );


    $lab = 'dzsap-thumb';
    $html_input = '<input id="attachments-' . $post->ID . '-' . $lab . '" class="upload-target-prev" name="attachments[' . $post->ID . '][' . $lab . ']"';
    if (get_post_meta($the_id, '_' . $lab, true) != '') {
      $html_input .= ' value="' . get_post_meta($the_id, '_' . $lab, true) . '"';
    }
    $html_input .= '/> <a rel="nofollow" href="#" class="dzs-wordpress-uploader button-secondary">' . esc_html__('Upload', DZSAP_ID) . '</a>';

    $form_fields[$lab] = array(
      'label' => __('Thumbnail', DZSAP_ID),
      'input' => 'html',
      'html' => $html_input,
      'helps' => __('choose a thumbnail / optional', DZSAP_ID),
    );


    $lab = 'dzsap_sourceogg';
    $html_input = '<input id="attachments-' . $post->ID . '-' . $lab . '" class="upload-target-prev upload-type-audio" name="attachments[' . $post->ID . '][' . $lab . ']"';
    if (get_post_meta($the_id, '_' . $lab, true) != '') {
      $html_input .= ' value="' . get_post_meta($the_id, '_' . $lab, true) . '"';
    }
    $html_input .= '/><button class="dzs-wordpress-uploader button-secondary">' . __('Upload', DZSAP_ID) . '</button>';

    $form_fields[$lab] = array(
      'label' => esc_html__('OGG Source', DZSAP_ID),
      'input' => 'html',
      'html' => $html_input,
      'helps' => 'optional - if you do not set this, the full flash player backup will kick in.',
    );


    return $form_fields;
  }

  function filter_attachment_fields_to_save($post, $attachment) {
    //print_r($post);
    $pid = $post['ID'];

    $lab = 'dzsap-thumb';
    if (isset($attachment[$lab])) {
      update_post_meta($pid, '_' . $lab, $attachment[$lab]);
    }
    $lab = 'dzsap_sourceogg';
    if (isset($attachment[$lab])) {
      update_post_meta($pid, '_' . $lab, $attachment[$lab]);
    }


    error_log('$thePost - '.print_r($post,true));

    return $post;
  }

  function checkInitCalls() {
    global $pagenow;
    $dzsap = $this->dzsap;

    $post_id = '';
    if (isset($_GET['post']) && $_GET['post'] != '') {
      $post_id = $_GET['post'];
    }

    if ($pagenow == 'post.php') {
      $po = get_post($post_id);
      if ($po && $po->post_type == 'attachment') {
        wp_enqueue_media();
      }
    }
    if (isset($_GET['page'])) {
      if ($_GET['page'] == DZSAP_ADMIN_PAGENAME_LEGACY_SLIDERS_ADMIN_SLIDERS || $_GET['page'] == DZSAP_ADMIN_PAGENAME_LEGACY_SLIDERS_ADMIN_VPCONFIGS) {
        wp_enqueue_media();
      }
    }


    if (isset($_GET['taxonomy']) && $_GET['taxonomy'] == DZSAP_TAXONOMY_NAME_SLIDERS) {
      wp_enqueue_script('jquery-ui-sortable');
      $url = 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css';

      if ($dzsap->mainoptions['fontawesome_load_local'] == 'on') {
        $url = DZSAP_BASE_URL . 'libs/fontawesome/font-awesome.min.css';
      }


      wp_enqueue_style('fontawesome', $url);
      wp_enqueue_style('dzs.tooltip', DZSAP_BASE_URL . 'libs/dzstooltip/dzstooltip.css');


      wp_enqueue_media();
    }


    if (isset($_GET['page']) && $_GET['page'] == DZSAP_ADMIN_PAGENAME_MAINOPTIONS) {

      DZSZoomSoundsHelper::enqueueScriptsForAdminMainOptions();

    }


    if (current_user_can('manage_options') || current_user_can('edit_posts') || current_user_can('edit_pages') || current_user_can('dzsap_make_shortcode')) {

      wp_enqueue_script('dzsap_htmleditor', DZSAP_BASE_URL . 'shortcodegenerator/add-generators-to-mce.js');
      wp_enqueue_script('dzsap_configreceiver', DZSAP_BASE_URL . 'tinymce/receiver.js');
    }

  }

  function permalink_settings() {

    echo wpautop(__('These settings control the permalinks used for audio items. These settings only apply when <strong>not using "default" permalinks above</strong>.', DZSAP_ID));

    $permalinks = get_option('dzsap_permalinks');
    $dzsap_permalink = '';

    if (isset($permalinks['item_base'])) {

      $dzsap_permalink = $permalinks['item_base'];
    }
    //echo 'ceva';

    $item_base = _x('audio', 'default-slug', DZSAP_ID);

    $structures = array(0 => '', 1 => '/' . trailingslashit($item_base));
    ?>
    <table class="form-table">
      <tbody>
      <tr>
        <th><label><input name="dzsap_permalink" type="radio" value="<?php echo $structures[0]; ?>"
                          class="dzsaptog" <?php checked($structures[0], $dzsap_permalink); ?> /> <?php _e('Default'); ?>
          </label></th>
        <td><code><?php echo home_url(); ?>/?audio=sample-item</code></td>
      </tr>
      <tr>
        <th><label><input name="dzsap_permalink" type="radio" value="<?php echo $structures[1]; ?>"
                          class="dzsaptog" <?php checked($structures[1], $dzsap_permalink); ?> /> <?php _e('Product', DZSAP_ID); ?>
          </label></th>
        <td><code><?php echo home_url(); ?>/<?php echo $item_base; ?>/sample-item/</code></td>
      </tr>
      <tr>
        <th><label><input name="dzsap_permalink" id="dzsap_custom_selection" type="radio" value="custom"
                          class="tog" <?php checked(in_array($dzsap_permalink, $structures), false); ?> />
            <?php _e('Custom Base', DZSAP_ID); ?></label></th>
        <td>
          <input name="dzsap_permalink_structure" id="dzsap_permalink_structure" type="text"
                 value="<?php echo esc_attr($dzsap_permalink); ?>" class="regular-text code"> <span
            class="description"><?php _e('Enter a custom base to use. A base <strong>must</strong> be set or WordPress will use default instead.', DZSAP_ID); ?></span>
        </td>
      </tr>
      </tbody>
    </table>
    <script type="text/javascript">
      jQuery(function () {
        jQuery('input.dzsaptog').change(function () {
          jQuery('#dzsap_permalink_structure').val(jQuery(this).val());
        });

        jQuery('#dzsap_permalink_structure').focus(function () {
          jQuery('#dzsap_custom_selection').click();
        });
      });
    </script>
    <?php
  }


  function handle_admin_init() {

    $dzsap = $this->dzsap;

    if (isset($_GET['dzsap_preview_player']) && $_GET['dzsap_preview_player'] === 'on') {
      wp_enqueue_style('dzs.remove_wp_bar', DZSAP_BASE_URL . 'tinymce/remove_wp_bar.css');
    }


    if ($dzsap->mainoptions['activate_comments_widget'] == 'on') {
      add_action('wp_dashboard_setup', array($this, 'wp_dashboard_setup'));
    }



    if ($dzsap->mainoptions['analytics_enable'] == 'on') {
      include_once(DZSAP_BASE_PATH."class_parts/analytics.php");
      add_action('wp_dashboard_setup', array($this, 'wp_dashboard_setup'));
    }


//        echo 'ceva';
    if ($dzsap->mainoptions['analytics_enable'] == 'on') {
      wp_enqueue_script('google.charts', 'https://www.gstatic.com/charts/loader.js');
      if ($dzsap->mainoptions['analytics_enable_location'] == 'on') {
        wp_enqueue_script('google.maps', 'https://www.google.com/jsapi');
      }
    }

    add_settings_section('dzsap-permalink', __('Audio Items Permalink Base', DZSAP_ID), array($this, 'permalink_settings'), 'permalink');


    if ($dzsap->mainoptions['analytics_table_created'] == 'off') {
      dzsap_analytics_table_create();
    }



    // -- use javascript - window.wp_pseudoHighlightMenuItem
    if (isset($_GET['page']) && $_GET['page'] == DZSAP_ADMIN_PAGENAME_PARENT) {
      if ($dzsap->mainoptions['playlists_mode'] == 'normal') {
        wp_redirect(admin_url('edit-tags.php?taxonomy=dzsap_sliders&post_type='.DZSAP_REGISTER_POST_TYPE_NAME));
        exit;
      }
    }

  }

  function handle_admin_head_start() {


  }
  function handle_admin_head() {
    $dzsap = $this->dzsap;

    if (isset($_GET['dzsap_preview_player']) && $_GET['dzsap_preview_player'] === 'on') {

      include_once(DZSAP_BASE_PATH . 'class_parts/admin-preview-player.php');
      dzsap_preview_player__headScripts();
    }


    if ($dzsap->mainoptions['enable_auto_backup'] == 'on') {

      $last_backup = get_option('dzsap_last_backup');


//            error_log('$last_backup - '.$last_backup) ;
      if ($last_backup) {

        $timestamp = time();
        if (abs($timestamp - $last_backup) > (3600 * 24 * 1)) {

          $this->do_backup();
        }

      } else {
        $this->do_backup();
      }
    }





    if (isset($_GET['taxonomy']) && $_GET['taxonomy'] == DZSAP_TAXONOMY_NAME_SLIDERS) {

      ?>
      <style>body.taxonomy-dzsap_sliders .wrap, .dzsap-sliders-con {
              opacity: 0;
              transition: opacity 0.3s ease-out;
          }

          body.taxonomy-dzsap_sliders.sliders-loaded .wrap, body.taxonomy-dzsap_sliders.sliders-loaded .dzsap-sliders-con {
              opacity: 1;
          }
      </style>
      <?php
    }




    if (isset($_GET['page']) && $_GET['page'] == DZSAP_ADMIN_PAGENAME_ABOUT) {

      wp_enqueue_style('dzsvg', DZSAP_BASE_URL . 'libs/videogallery/vplayer.css');
      wp_enqueue_script('dzsvg', DZSAP_BASE_URL . "libs/videogallery/vplayer.js");
    }



    include(DZSAP_BASE_PATH . "configs/options-item-meta.php");
    DZSZoomSoundsHelper::enqueueScriptsForAdminGeneral();

    // -- admin_head


  }
  function admin_page() {

    $dzsap = $this->dzsap;
    // -- old Sliders Admin
    include_once DZSAP_BASE_PATH . "inc/php/deprecated-sliders-admin.php";
  }

  function admin_page_vpc() {

    include_once DZSAP_BASE_PATH . "class_parts/admin-page-audioPlayerConfigs.php";

    dzsap_admin_page_vpc();
  }

  function handle_add_meta_boxes() {

    $dzsap = $this->dzsap;

    add_meta_box('dzsap_footer_player_options', esc_html__('Footer Player Settings', DZSAP_ID), array($this, 'admin_meta_options'), 'page', 'normal', 'high');
    add_meta_box('dzsap_footer_player_options', esc_html__('Footer Player Settings', DZSAP_ID), array($this, 'admin_meta_options'), 'post', 'normal', 'high');
    add_meta_box('dzsap_footer_player_options', esc_html__('Footer Player Settings', DZSAP_ID), array($this, 'admin_meta_options'), 'product', 'normal', 'high');


    // -- deprecated!
    add_meta_box('dzsap_waveform_generation', __('ZoomSounds Waveforms'), 'dzsap_admin_meta_download_waveforms', 'download', 'normal', 'high');


    add_meta_box('dzsap_meta_options', esc_html__('Audio Item Settings', DZSAP_ID), array($this, 'dzsap_admin_meta_options'), DZSAP_REGISTER_POST_TYPE_NAME, 'normal', 'high');


    $meta_post_array = $dzsap->mainoptions['dzsap_meta_post_types'];


    if ($meta_post_array && is_array($meta_post_array) && count($meta_post_array)) {


      foreach ($meta_post_array as $post_type) {
        if ($post_type == DZSAP_REGISTER_POST_TYPE_NAME) {
          continue;
        }
//      print_rr($meta_post_array);
//        echo '$post_type - '.print_r($post_type,true);


        if($post_type){
          add_meta_box('dzsap_meta_options', esc_html__('Audio Item Settings', DZSAP_ID), array($this, 'dzsap_admin_meta_options'), $post_type, 'normal');
        }

      }
    }


  }


  function admin_meta_save($post_id) {
    global $post;
    if (!$post) {
      return;
    }
    /* Check autosave */
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
      return $post_id;
    }
    if (isset($_REQUEST['dzs_nonce'])) {
      $nonce = $_REQUEST['dzs_nonce'];
      if (!wp_verify_nonce($nonce, 'dzs_nonce'))
        wp_die('Security check');
    }
    if (is_array($_POST)) {
      $auxa = $_POST;
      foreach ($auxa as $label => $value) {

        //print_r($label); print_r($value);
        if (strpos($label, 'dzsap_') !== false) {
          dzs_savemeta($post->ID, $label, $value);
        }
      }
    }
  }

  function dzsap_admin_meta_options() {
    global $post, $wp_version;
    $dzsap = $this->dzsap;


    ?>

    <?php
    include_once(DZSAP_BASE_PATH.'class_parts/item-meta.php');

    wp_enqueue_style('dzsselector', DZSAP_BASE_URL . 'libs/dzsselector/dzsselector.css');
    wp_enqueue_script('dzsselector', DZSAP_BASE_URL . 'libs/dzsselector/dzsselector.js');
  }


  function admin_page_about() {
    $dzsap = $this->dzsap;

    include_once(DZSAP_BASE_PATH.'class_parts/admin-page-about.php');


    DZSZoomSoundsHelper::embedZoomTabsAndAccordions();

    $url = 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css';

    if ($dzsap->mainoptions['fontawesome_load_local'] == 'on') {
      $url = DZSAP_BASE_URL . 'libs/fontawesome/font-awesome.min.css';
    }


    wp_enqueue_style('fontawesome', $url);

  }


  function admin_page_autoupdater() {

    include_once DZSAP_BASE_PATH . 'class_parts/admin-page-autoupdater.php';
    dzsap_admin_page_autoupdater();
  }

  function admin_meta_options() {
    global $post;


    $dzsap = $this->dzsap;

    $struct_uploader = '
<a rel="nofollow" href="#" class="button-secondary dzs-wordpress-uploader">' . __('Upload', DZSAP_ID) . '</a>
';



    $vpconfigs_arr = array(
      array('lab' => 'default', 'val' => 'default')
    );

    $i23 = 0;
    foreach ($dzsap->mainitems_configs as $vpconfig) {
      //print_r($vpconfig);


      $auxa = array(
        'lab' => $vpconfig['settings']['id'],
        'val' => $vpconfig['settings']['id'],
        'extraattr' => 'data-sliderlink="' . $i23 . '"',
      );

      array_push($vpconfigs_arr, $auxa);

      $i23++;
    }


    ?>
    <div class="dzsap-meta-bigcon">
      <input type="hidden" name="dzs_nonce" value="<?php echo wp_create_nonce('dzs_nonce'); ?>"/>


      <?php
      ?>


      <div class="dzs-setting">
        <?php
        $lab = 'dzsap_footer_enable';

        echo DZSHelpers::generate_input_text($lab, array(
          'class' => 'fake-input',
          'def_value' => '',
          'seekval' => 'off',
          'input_type' => 'hidden',
        ));
        ?>
        <h4><?php echo __('Enable Sticky Player', DZSAP_ID); ?></h4>
        <?php

        echo '<div class="dzscheckbox skin-nova">
                                        ' . DZSHelpers::generate_input_checkbox($lab, array('id' => $lab, 'class' => 'mainsetting dzs-dependency-field', 'val' => 'on', 'seekval' => get_post_meta($post->ID, $lab, true))) . '
                                        <label for="' . $lab . '"></label>
                                    </div>';


        // -- for future we can do a logical set like "(" .. ")" .. "AND" .. "OR"
        $dependency = array(

          array(
            'lab' => 'dzsap_footer_enable',
            'val' => array('on'),
          ),
          //                    'relation'=>'AND',
        );


        ?>

      </div>


      <div data-dependency='<?php echo json_encode($dependency); ?>'>

        <?php


        $feed_type = array(
          array(
            'lab' => 'parent',
            'val' => 'parent',
          ),
          array(
            'lab' => 'custom',
            'val' => 'custom',
          ),
        );
        ?>


        <div class="dzs-setting ">
          <h4><?php echo __('Feed Type', DZSAP_ID); ?></h4>
          <?php
          $lab = 'dzsap_footer_feed_type';
          echo DZSHelpers::generate_select($lab, array('class' => 'dzs-style-me  dzs-dependency-field opener-listbuttons', 'options' => $feed_type, 'seekval' => get_post_meta($post->ID, $lab, true)));


          ?>

          <ul class="dzs-style-me-feeder">

            <div class="bigoption">
                          <span class="option-con"><img
                              src="<?php echo DZSAP_BASE_URL; ?>tinymce/img/footer_type_parent.png"><span
                              class="option-label"><?php echo __("Parent Player"); ?></span></span>
            </div>

            <div class="bigoption">
                          <span class="option-con"><img
                              src="<?php echo DZSAP_BASE_URL; ?>tinymce/img/footer_type_media.png"><span
                              class="option-label"><?php echo __("Custom Media"); ?></span></span>
            </div>

          </ul>


          <div class="sidenote">
            <?php echo esc_html__('Select parent player for the sticky player to await being played from the outside ( a track on the page or select custom media to set a custom mp3 to play directly in the sticky player.', DZSAP_ID); ?>
          </div>

        </div>


        <div class="dzs-setting vpconfig-wrapper">
          <h4><?php echo __('Player configuration', DZSAP_ID); ?></h4>
          <?php
          $lab = 'dzsap_footer_vpconfig';
          echo DZSHelpers::generate_select($lab, array('class' => 'vpconfig-select styleme', 'options' => $vpconfigs_arr, 'seekval' => get_post_meta($post->ID, $lab, true))); ?>

          <div class="edit-link-con" style="margin-top: 10px;"></div>

        </div>


        <?php


        // -- for future we can do a logical set like "(" .. ")" .. "AND" .. "OR"
        $dependency = array(

          array(
            'lab' => 'dzsap_footer_feed_type',
            'val' => array('custom'),
          ),
          //                    'relation'=>'AND',
        );


        ?>

        <div class="dzs-setting" data-dependency='<?php echo json_encode($dependency); ?>'>
          <h4><?php echo esc_html__('Featured Media', DZSAP_ID); ?></h4>
          <?php
          $lab = 'dzsap_footer_featured_media';
          echo DZSHelpers::generate_input_text($lab, array('class' => 'input-big-image upload-target-prev', 'def_value' => '', 'seekval' => get_post_meta($post->ID, $lab, true))); ?>
          <?php echo $struct_uploader; ?>

        </div>

        <div class="dzs-setting" data-dependency='<?php echo json_encode($dependency); ?>'>
          <h4><?php echo esc_html__('Song name', DZSAP_ID); ?></h4>
          <?php
          $lab = 'dzsap_footer_song_name';
          echo DZSHelpers::generate_input_text($lab, array('class' => 'input-big-image  ', 'def_value' => '', 'seekval' => get_post_meta($post->ID, $lab, true))); ?>

        </div>

        <?php


        ?>


        <div class="dzs-setting " data-dependency='<?php echo json_encode($dependency); ?>'>
          <h4><?php echo esc_html__('Media Type', DZSAP_ID); ?></h4>
          <?php
          $types_arr = array(
            array('lab' => 'audio', 'val' => 'audio'),
            array('lab' => 'shoutcast', 'val' => 'shoutcast'),
            array('lab' => 'soundcloud', 'val' => 'soundcloud'),
            array('lab' => 'youtube', 'val' => 'youtube'),
            array('lab' => 'fake', 'val' => 'fake'),
          );
          $lab = 'dzsap_footer_type';
          echo DZSHelpers::generate_select($lab, array('class' => ' styleme', 'options' => $types_arr, 'seekval' => get_post_meta($post->ID, $lab, true))); ?>

          <div class="edit-link-con"></div>
        </div>


      </div>


    </div>


    <?php
  }


}