<?php
//error_log("ceva");
@include_once(DZSAP_BASE_PATH . "configs/constants.php");
@include_once(DZSAP_BASE_PATH . "class_parts/class-ajax-functions.php");
@include_once(DZSAP_BASE_PATH . "inc/php/database-functions.php");
@include_once(DZSAP_BASE_PATH . "inc/php/DZSZoomSoundsHelper.php");
@include_once(DZSAP_BASE_PATH . "inc/php/DzsapView.php");
@include_once(DZSAP_BASE_PATH . "inc/php/DzsapAdmin.php");
@include_once(DZSAP_BASE_PATH . "inc/php/AjaxHandler.php");
@include_once(DZSAP_BASE_PATH . "inc/portal/showcase-functions.php");
@include_once(DZSAP_BASE_PATH . "inc/php/analytics.php");
@include_once(DZSAP_BASE_PATH . "inc/php/deprecated/legacy-sliders.php");
@include_once(DZSAP_BASE_PATH . "inc/php/deprecated.php");
@include_once(DZSAP_BASE_PATH . "inc/php/view-functions.php");
@include_once(DZSAP_BASE_PATH . "inc/php/gutenberg-functions.php");
@include_once(DZSAP_BASE_PATH . "inc/php/shortcodes.php");
@include_once(DZSAP_BASE_PATH . "inc/php/view-parseItems/parse-items-functions.php");


class DZSAudioPlayer {


  public $admin_capability = 'manage_options';

  public $pageName_legacy_sliders_admin_vpconfigs = 'dzsap_configs';


  public $the_shortcode = 'zoomsounds';
  public $mainitems;
  public $mainitems_configs;
  public $mainoptions;
  public $sliders_index = 0;
  public $sliders__player_index = 0;
  public $cats_index = 0;
  public $dbs = array();
  public $currDb = '';
  public $vpconfigsstr = '';
  public $currSlider = '';
  public $current_user_id = 0;
  public $videoplayerconfig = '';

  public $alwaysembed = "on";

  public $general_assets = array();
  public $sample_data = array();


  public $options_item_meta = array();
  public $options_item_meta_sanitized = array(); // -- removing dzsap_meta_
  public $og_data = array();


  public $db_has_read_mainitems = false;

  public $sliderstructure = ''; // -- deprecated

  public $options_array_player = array();
  public $options_slider = array();
  public $options_slider_categories_lng = array();
  public $item_meta_categories_lng = array();


  public $isEnableMultisharer = false;
  public $debug = false;

  public $footer_style = '';
  public $footer_style_configs = array();
  public $footer_script = '';

  public $extraCssConsumedConfigurations = array();


  public $svg_star = '';

  public $classView;
  public $classAdmin;
  public $classWoo;
  public $ajax_functions = null;

  public $audioPlayerConfigs = array();

  function __construct() {




    $this->general_assets = DZSZoomSoundsHelper::get_assets();


    $this->svg_star = $this->general_assets['svg_star'];

    //clear database


    // -- classes init
    $this->classView = new DzsapView($this);
    $this->classAdmin = new DzsapAdmin($this);
    $this->ajax_functions = new AjaxHandler($this);


    add_action('init', array($this, 'handle_init'), 2);


    add_action('edited_' . DZSAP_TAXONOMY_NAME_SLIDERS, 'dzsap_sliders_save_taxonomy_custom_meta');
  }


  function db_read_default_opts() {
    DZSZoomSoundsHelper::dbReadOptions($this);
  }

  /**
   * called at priority 2
   */
  function handle_init() {
    global $current_user;

    if ($current_user->ID) {
      $this->current_user_id = $current_user->ID;
    }

    if (defined('DZSAP_DEBUG_LOCAL_SCRIPTS') && DZSAP_DEBUG_LOCAL_SCRIPTS === true) {
      wp_deregister_script('heartbeat');
    }

    $this->item_meta_categories_lng = array(
      'misc' => esc_html__("Miscellaneous", DZSAP_ID),
      'extra_html' => esc_html__("Extra HTML", DZSAP_ID),
    );

    $this->db_read_default_opts();

    $this->ajax_functions->ajaxCheckPostOptions();

    if (function_exists('WC')) {
//      echo 'dada';
//      echo 'whatata';
      include(DZSAP_BASE_PATH . '/inc/php/DzsapWooCommerce.php');
      $this->classWoo = new DzsapWooCommerce($this);
      dzsap_woo_woocommerce_init();
    }

//    require_once("configs/options_gallery.php");
    require_once(DZSAP_BASE_PATH . "class_parts/options_array_player.php");


    if ($this->mainoptions['playlists_mode'] == 'legacy') {
      dzsap_deprecated_init_slider_structure();
    }

    // todo: why do we have this ?
    include DZSAP_BASE_PATH . "class_parts/vpconfig.php";


    dzsap_gutenberg_init();


    // --- check posts
    if (isset($_GET['dzsap_shortcode_builder']) && $_GET['dzsap_shortcode_builder'] == 'on') {
//            dzsprx_shortcode_builder();

      include_once(dirname(__FILE__) . '/tinymce/popupiframe.php');
      define('DONOTCACHEPAGE', true);
      define('DONOTMINIFY', true);

    }


    if (isset($_GET['dzsap_shortcode_player_builder']) && $_GET['dzsap_shortcode_player_builder'] == 'on') {
//            dzsprx_shortcode_builder();
      include_once(dirname(__FILE__) . '/shortcodegenerator/generator_player.php');
      if (!defined("DONOTCACHEPAGE")) {
        define('DONOTCACHEPAGE', true);
      }
      if (!defined("DONOTMINIFY")) {
        define('DONOTMINIFY', true);
      }
    }


//        return false;


    // -- ajax actions


    dzsap_shortcode_init_listeners();


    add_action('wp_head', array($this, 'handle_wp_head'));


    if ($this->ajax_functions) {
      $this->ajax_functions->register_actions();
    }




    if (isset($_GET) && isset($_GET['load-lightbox-css']) && $_GET['load-lightbox-css'] == 'on') {
      header("Content-type: text/css");
      include_once "class_parts/lightbox_css.php";
      die();
    }


    if ($this->mainoptions['try_to_hide_url'] == 'on') {

      if (!session_id()) {
        session_start();
      }
    }


    if (isset($_GET['dzsap_action']) && $_GET['dzsap_action']) {
      include DZSAP_BASE_PATH . 'class_parts/part-ajax-functions.php';
    }

    //wp_deregister_script('jquery');        wp_register_script('jquery', ("https://ajax.googleapis.com/ajax/libs/jquery/1.9.0/jquery.min.js"), false, '1.9.0');
    wp_enqueue_script('jquery');
    if (is_admin()) {

      $this->classAdmin->checkInitCalls();

    } else {
      if (isset($this->mainoptions['always_embed']) && $this->mainoptions['always_embed'] == 'on') {
        $this->front_scripts();
        DZSZoomSoundsHelper::enqueueUltibox();
      }
    }


    dzsap_register_links();
    dzsap_gutenberg_register_scripts();



    if (function_exists('vc_map')) {
      include_once(DZSAP_BASE_PATH . 'inc/php/vc/part-vcintegration.php');
    }
  }

  // --- end handle_init END
  // -----------------------


  function handle_init_end() {


    if ($this->mainoptions['replace_powerpress_plugin'] == 'on') {
      add_shortcode('powerpress', 'dzsap_powerpress_shortcode_player');
    }


//        echo "get_option('dzsap_sample_data_installed') - ".get_option('dzsap_sample_data_installed');

    if (!(get_option('dzsap_sample_data_installed'))) {
      $tax = DZSAP_TAXONOMY_NAME_SLIDERS;
      $reference_term = get_term_by('slug', 'gallery-1-copy', $tax);
//		    echo '$reference_term - ';print_rr($reference_term);
      if (!$reference_term) {
        $file_cont = file_get_contents('sampledata/dzsap_export_gallery.txt', true);
//			    error_log('trying to import - '.$file_cont);
        ZoomSoundsAjaxFunctions::import_slider($file_cont);
      }
      update_option('dzsap_sample_data_installed', 'on');

//	        echo ' $file_cont - '.$file_cont;
//	        echo ' $sw_import - '.$sw_import;
    }

  }


  /**
   * get main items in $dzsap->mainitems
   * used in various options for normal mode
   * used for slidersAdmin in legacy mode
   */
  function db_read_mainitems() {
    DZSZoomSoundsHelper::dbReadMainItems($this);
  }


  function handle_wp_head() {

    global $post;
    echo '<script>';
    echo 'window.ajaxurl="' . admin_url('admin-ajax.php') . '";';
    echo 'window.dzsap_curr_user="' . get_current_user_id() . '";';
    echo 'window.dzsap_settings= { dzsap_site_url: "' . site_url() . '/",wpurl: "' . site_url() . '/",version: "' . DZSAP_VERSION . '",ajax_url: "' . admin_url('admin-ajax.php') . '", debug_mode:"' . $this->mainoptions['debug_mode'] . '" ';


//        echo ' $this->mainoptions - '; print_rr($this->mainoptions);
    $lab = 'dzsaap_default_portal_upload_type';
    if ($this->mainoptions[$lab] && $this->mainoptions[$lab] != 'audio') {
      echo ',' . $lab . ':"' . $this->mainoptions[$lab] . '"';
    }
    if ($post && $post->post_type == 'dzsap_items') {
      echo ',playerid: "' . $post->ID . '"';
    }
    echo '}; ';


    DZSZoomSoundsHelper::echoJavascriptKeyboardControls($this);

    echo '</script>';

    echo '<style class="dzsap-extrastyling">.feed-dzsap{ display:none; }';
    if ($this->mainoptions['extra_css']) {
      echo $this->mainoptions['extra_css'];
    }
    echo '</style>';


//        echo 'is_tax - '.;


    if (is_tax(DZSAP_TAXONOMY_NAME_SLIDERS) || ($this->mainoptions['single_index_seo_disable'] == 'on' && is_singular('dzsap_items'))) {
      echo '<meta name="robots" content="noindex, follow">';
    }

//        print_rr($post);
    if ($this->mainoptions['replace_powerpress_plugin'] == 'on') {
      global $post;
      if ($post) {
        if ($post->ID != '4812' && $post->ID != '23950') {
          $this->mainoptions['replace_powerpress_plugin'] = 'off';
        }
      }
    }

    if (isset($_GET['dzsap_generate_pcm']) && $_GET['dzsap_generate_pcm']) {
      include DZSAP_BASE_PATH . 'class_parts/part-regenerate-waves-player.php';
    }

  }
  function get_track_source($sourceid, &$playerid, &$margs) {
    return DZSZoomSoundsHelper::media_getTrackSource($sourceid, $playerid, $margs);
  }
  function parse_items($its, $pargs = array(), $argPlaylistOptions = array()) {
    return $this->classView->parse_items($its, $pargs, $argPlaylistOptions);
  }
  function front_scripts() {
    DZSZoomSoundsHelper::enqueueMainScrips();
  }
  /** deprecated 5.89
   * @param $pargs
   */
  function shortcode_player($pargs) {
    return $this->classView->shortcode_player($pargs);
  }
}



